/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.velocity.VelocityContext;
import org.gitools.heatmap.Heatmap;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.ActionSet;
import org.gitools.ui.platform.actions.ActionSetUtils;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.panel.TemplatePanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.LogUtils;
import org.gitools.ui.wizard.common.SaveFileWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTablesPanel<A>
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(AbstractTablesPanel.class);
    protected static final boolean DEFAULT_AUTOMATIC_UPDATE = false;
    protected static final int DATA_VIEW_MODE = 1;
    protected static final int RESULTS_VIEW_MODE = 2;
    protected A analysis;
    protected Heatmap heatmap;
    protected int viewMode;
    protected boolean automaticUpdate;
    protected boolean forceUpdate;
    private TemplatePanel templatePanel;

    public AbstractTablesPanel(A analysis, Heatmap heatmap) {
        this.analysis = analysis;
        this.heatmap = heatmap;
        this.viewMode = 1;
        this.automaticUpdate = false;
        this.forceUpdate = false;
        this.createComponents();
        heatmap.getMatrixView().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTablesPanel.this.propertyChange(evt);
            }
        });
    }

    private void createComponents() {
        JToolBar toolBar = this.createToolBar();
        this.templatePanel = new TemplatePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        this.add((Component)this.templatePanel, "Center");
    }

    private JToolBar createToolBar() {
        return ActionSetUtils.createToolBar((ActionSet)new ActionSet(new BaseAction[]{new DataAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTablesPanel.this.setViewMode(1);
            }
        }, new ResultsAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTablesPanel.this.setViewMode(2);
            }
        }, new ExportHtmlAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTablesPanel.this.saveHtml();
            }
        }, new AutomaticUpdateAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTablesPanel.this.setAutomaticUpdate(!AbstractTablesPanel.this.isAutomaticUpdate());
                AbstractTablesPanel.this.updateContents();
            }
        }, new ForceUpdateAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTablesPanel.this.forceUpdate();
            }
        }}));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (evt.getSource() == this.heatmap.getMatrixView() && "selectionLead".equals(name)) {
            this.updateContents();
        }
    }

    private void updateContents() {
        if (!this.automaticUpdate && !this.forceUpdate) {
            return;
        }
        this.forceUpdate = false;
        VelocityContext context = this.createModel();
        context.put("exporting", (Object)false);
        String template = context.get("__template__").toString();
        try {
            URL url = this.getClass().getResource(template);
            this.templatePanel.setTemplateFromResource(template, url);
            this.templatePanel.render(context);
        }
        catch (Exception ex) {
            LogUtils.logException(ex, log);
        }
    }

    protected abstract VelocityContext createModel();

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
        this.updateContents();
    }

    public boolean isAutomaticUpdate() {
        return this.automaticUpdate;
    }

    public void setAutomaticUpdate(boolean automaticUpdate) {
        this.automaticUpdate = automaticUpdate;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
        this.updateContents();
    }

    protected void saveHtml() {
        AbstractEditor editor = AppFrame.instance().getEditorsPanel().getSelectedEditor();
        if (editor == null) {
            return;
        }
        SaveFileWizard saveWiz = SaveFileWizard.createSimple("Export html ...", PersistenceUtils.getFileName((String)editor.getName()), Settings.getDefault().getLastExportPath(), new FileFormat[]{FileFormats.HTML});
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)saveWiz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        Settings.getDefault().setLastExportPath(saveWiz.getFolder());
        final File file = saveWiz.getPathAsFile();
        String formatExtension = saveWiz.getFormat().getExtension();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Exporting html ...", 1);
                    monitor.info("File: " + file.getName());
                    VelocityContext context = AbstractTablesPanel.this.createModel();
                    context.put("exporting", (Object)true);
                    String template = context.get("__template__").toString();
                    try {
                        URL url = this.getClass().getResource(template);
                        AbstractTablesPanel.this.templatePanel.setTemplateFromResource(template, url);
                        AbstractTablesPanel.this.templatePanel.render(context);
                    }
                    catch (Exception ex) {
                        LogUtils.logException(ex, log);
                    }
                    FileWriter writer = new FileWriter(file);
                    AbstractTablesPanel.this.templatePanel.merge(context, (Writer)writer);
                    ((Writer)writer).close();
                    monitor.end();
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText("Ok.");
    }

    private static abstract class ForceUpdateAction
    extends BaseAction {
        public ForceUpdateAction() {
            super("Update");
            this.setDesc("Update tables");
        }
    }

    private static abstract class AutomaticUpdateAction
    extends BaseAction {
        public AutomaticUpdateAction() {
            super("Automatic update", true, false, null);
            this.setDesc("The tables are automatically updated when heatmap cursor changes");
        }
    }

    private static abstract class ExportHtmlAction
    extends BaseAction {
        public ExportHtmlAction() {
            super("Export html...");
            this.setDesc("Export html");
            this.setLargeIconFromResource("/img/Save24.gif");
            this.setSmallIconFromResource("/img/Save16.gif");
        }
    }

    private static abstract class ResultsAction
    extends BaseAction {
        public ResultsAction() {
            super("Results", true, false, "template");
        }
    }

    private static abstract class DataAction
    extends BaseAction {
        public DataAction() {
            super("Data", true, true, "template");
        }
    }
}

