/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.correlation.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.help.HelpContext;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class CorrelationFromFilePage
extends AbstractWizardPage {
    private ButtonGroup applyGroup;
    private JRadioButton applyToColumnsRb;
    private JRadioButton applyToRowsRb;
    private JLabel jLabel2;
    private JCheckBox replaceEmptyValuesCheck;
    private JTextField replaceValueField;

    public CorrelationFromFilePage() {
        this.initComponents();
        this.setTitle("Configure correlation options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setHelpContext(new HelpContext("analysis_correlation"));
        this.setComplete(true);
        this.replaceEmptyValuesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrelationFromFilePage.this.replaceValueField.setEnabled(CorrelationFromFilePage.this.replaceEmptyValuesCheck.isSelected());
            }
        });
        this.replaceValueField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                boolean valid = CorrelationFromFilePage.this.isValidNumber(CorrelationFromFilePage.this.replaceValueField.getText());
                boolean completed = !CorrelationFromFilePage.this.replaceEmptyValuesCheck.isSelected() || valid;
                CorrelationFromFilePage.this.setComplete(completed);
                if (!valid) {
                    CorrelationFromFilePage.this.setStatus(MessageStatus.ERROR);
                    CorrelationFromFilePage.this.setMessage("Invalid replacement for empty values, it should be a real number");
                } else {
                    CorrelationFromFilePage.this.setMessage(MessageStatus.INFO, "");
                }
            }
        });
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.replaceEmptyValuesCheck = new JCheckBox();
        this.replaceValueField = new JTextField();
        this.jLabel2 = new JLabel();
        this.applyToColumnsRb = new JRadioButton();
        this.applyToRowsRb = new JRadioButton();
        this.replaceEmptyValuesCheck.setText("Replace empty values by");
        this.replaceValueField.setText("0");
        this.replaceValueField.setEnabled(false);
        this.jLabel2.setText("Apply to:");
        this.applyGroup.add(this.applyToColumnsRb);
        this.applyToColumnsRb.setSelected(true);
        this.applyToColumnsRb.setText("Columns");
        this.applyGroup.add(this.applyToRowsRb);
        this.applyToRowsRb.setText("Rows");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.replaceEmptyValuesCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceValueField, -2, 181, -2)).addComponent(this.jLabel2).addComponent(this.applyToColumnsRb).addComponent(this.applyToRowsRb)).addContainerGap(152, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceEmptyValuesCheck).addComponent(this.replaceValueField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyToColumnsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToRowsRb).addContainerGap(161, Short.MAX_VALUE)));
    }

    public JComponent createControls() {
        return this;
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public boolean isReplaceNanValuesEnabled() {
        return this.replaceEmptyValuesCheck.isSelected();
    }

    public void setReplaceNanValuesEnabled(boolean enabled) {
        this.replaceEmptyValuesCheck.setSelected(enabled);
    }

    public double getReplaceNanValue() {
        return Double.parseDouble(this.replaceValueField.getText());
    }

    public void setReplaceNanValue(double value) {
        this.replaceValueField.setText(Double.toString(value));
    }

    public boolean isTransposeEnabled() {
        return this.applyToRowsRb.isSelected();
    }

    public void setTransposeEnabled(boolean enabled) {
        this.applyToRowsRb.setSelected(enabled);
    }
}

