/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.correlation.wizard;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.wizard.AbstractWizardPage;
import org.gitools.ui.utils.DocumentChangeListener;

public class CorrelationFromEditorPage
extends AbstractWizardPage {
    protected String[] attributeNames;
    private ButtonGroup applyGroup;
    private JRadioButton applyToColumnsRb;
    private JRadioButton applyToRowsRb;
    private JComboBox attributeCb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox replaceEmptyValuesCheck;
    private JTextField replaceValueField;

    public CorrelationFromEditorPage(String[] attributeNames) {
        this.initComponents();
        this.setTitle("Configure correlation options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setComplete(true);
        this.attributeNames = attributeNames;
        this.attributeCb.setModel(new DefaultComboBoxModel<String>(attributeNames));
        this.replaceEmptyValuesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrelationFromEditorPage.this.replaceValueField.setEnabled(CorrelationFromEditorPage.this.replaceEmptyValuesCheck.isSelected());
            }
        });
        this.replaceValueField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            protected void update(DocumentEvent e) {
                boolean valid = CorrelationFromEditorPage.this.isValidNumber(CorrelationFromEditorPage.this.replaceValueField.getText());
                boolean completed = !CorrelationFromEditorPage.this.replaceEmptyValuesCheck.isSelected() || valid;
                CorrelationFromEditorPage.this.setComplete(completed);
                if (!valid) {
                    CorrelationFromEditorPage.this.setStatus(MessageStatus.ERROR);
                    CorrelationFromEditorPage.this.setMessage("Invalid replacement for empty values, it should be a real number");
                } else {
                    CorrelationFromEditorPage.this.setMessage(MessageStatus.INFO, "");
                }
            }
        });
    }

    private void initComponents() {
        this.applyGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.attributeCb = new JComboBox();
        this.replaceEmptyValuesCheck = new JCheckBox();
        this.replaceValueField = new JTextField();
        this.jLabel2 = new JLabel();
        this.applyToColumnsRb = new JRadioButton();
        this.applyToRowsRb = new JRadioButton();
        this.jLabel1.setText("Take values from");
        this.replaceEmptyValuesCheck.setText("Replace empty values by");
        this.replaceValueField.setText("0");
        this.replaceValueField.setEnabled(false);
        this.jLabel2.setText("Apply to:");
        this.applyGroup.add(this.applyToColumnsRb);
        this.applyToColumnsRb.setSelected(true);
        this.applyToColumnsRb.setText("Columns");
        this.applyGroup.add(this.applyToRowsRb);
        this.applyToRowsRb.setText("Rows");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributeCb, -2, 301, -2)).addGroup(layout.createSequentialGroup().addComponent(this.replaceEmptyValuesCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceValueField, -2, 181, -2)).addComponent(this.jLabel2).addComponent(this.applyToColumnsRb).addComponent(this.applyToRowsRb)).addContainerGap(100, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.attributeCb, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceEmptyValuesCheck).addComponent(this.replaceValueField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyToColumnsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToRowsRb).addContainerGap(116, Short.MAX_VALUE)));
    }

    public JComponent createControls() {
        return this;
    }

    private boolean isValidNumber(String text) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public int getAttributeIndex() {
        return this.attributeCb.getSelectedIndex();
    }

    public boolean isReplaceNanValuesEnabled() {
        return this.replaceEmptyValuesCheck.isSelected();
    }

    public double getReplaceNanValue() {
        return Double.parseDouble(this.replaceValueField.getText());
    }

    public boolean isTransposeEnabled() {
        return this.applyToRowsRb.isSelected();
    }
}

