/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.correlation.wizard;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.io.File;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.gitools.analysis.correlation.CorrelationAnalysis;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.correlation.wizard.CorrelationFromFilePage;
import org.gitools.ui.analysis.wizard.AnalysisDetailsPage;
import org.gitools.ui.analysis.wizard.DataFilePage;
import org.gitools.ui.analysis.wizard.DataFilterPage;
import org.gitools.ui.analysis.wizard.ExamplePage;
import org.gitools.ui.examples.ExamplesManager;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class CorrelationAnalysisFromFileWizard
extends AbstractWizard {
    private static final String EXAMPLE_ANALYSIS_FILE = "analysis.correlations";
    private static final String EXAMPLE_DATA_FILE = "8_kidney_6_brain_downreg_annot.cdm.gz";
    private ExamplePage examplePage;
    private DataFilePage dataPage;
    private DataFilterPage dataFilterPage;
    protected CorrelationFromFilePage corrPage;
    private SaveFilePage saveFilePage;
    protected AnalysisDetailsPage analysisDetailsPage;

    public CorrelationAnalysisFromFileWizard() {
        this.setTitle("Correlation analysis");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Correlation.png", (int)96));
        this.setHelpContext("analysis_correlation");
    }

    public void addPages() {
        if (Settings.getDefault().isShowCombinationExamplePage()) {
            this.examplePage = new ExamplePage("a correlation analysis");
            this.examplePage.setTitle("Correlation analysis");
            this.addPage((IWizardPage)this.examplePage);
        }
        this.dataPage = new DataFilePage();
        this.addPage((IWizardPage)this.dataPage);
        this.dataFilterPage = new DataFilterPage();
        this.dataFilterPage.setRowsFilterFileVisible(false);
        this.addPage((IWizardPage)this.dataFilterPage);
        this.corrPage = new CorrelationFromFilePage();
        this.addPage((IWizardPage)this.corrPage);
        this.saveFilePage = new SaveFilePage();
        this.saveFilePage.setTitle("Select destination file");
        this.saveFilePage.setFolder(Settings.getDefault().getLastWorkPath());
        this.saveFilePage.setFormats(new FileFormat[]{FileFormats.CORRELATIONS});
        this.saveFilePage.setFormatsVisible(false);
        this.addPage((IWizardPage)this.saveFilePage);
        this.analysisDetailsPage = new AnalysisDetailsPage();
        this.addPage((IWizardPage)this.analysisDetailsPage);
    }

    public void pageLeft(IWizardPage currentPage) {
        if (currentPage == this.examplePage) {
            Settings.getDefault().setShowCombinationExamplePage(this.examplePage.isShowAgain());
            if (this.examplePage.isExampleEnabled()) {
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        final File basePath = ExamplesManager.getDefault().resolvePath("correlations", monitor);
                        if (basePath == null) {
                            throw new RuntimeException("Unexpected error: There are no examples available");
                        }
                        File analysisFile = new File(basePath, CorrelationAnalysisFromFileWizard.EXAMPLE_ANALYSIS_FILE);
                        Properties props = new Properties();
                        props.setProperty("load_references", "false");
                        try {
                            monitor.begin("Loading example parameters ...", 1);
                            final CorrelationAnalysis a = (CorrelationAnalysis)PersistenceManager.getDefault().load(analysisFile, props, monitor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CorrelationAnalysisFromFileWizard.this.setAnalysis(a);
                                    CorrelationAnalysisFromFileWizard.this.dataPage.setFile(new File(basePath, CorrelationAnalysisFromFileWizard.EXAMPLE_DATA_FILE));
                                    CorrelationAnalysisFromFileWizard.this.saveFilePage.setFileNameWithoutExtension("example");
                                }
                            });
                            monitor.end();
                        }
                        catch (Exception ex) {
                            monitor.exception(ex);
                        }
                    }
                });
            }
        }
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        IWizardPage page = this.getCurrentPage();
        return canFinish |= page.isComplete() && page == this.saveFilePage;
    }

    public void performFinish() {
        Settings.getDefault().setLastWorkPath(this.saveFilePage.getFolder());
    }

    public String getWorkdir() {
        return this.saveFilePage.getFolder();
    }

    public String getFileName() {
        return this.saveFilePage.getFileName();
    }

    public String getDataFileMime() {
        return this.dataPage.getFileFormat().getMime();
    }

    public File getDataFile() {
        return this.dataPage.getFile();
    }

    public File getPopulationFile() {
        return this.dataFilterPage.getRowsFilterFile();
    }

    public CorrelationAnalysis getAnalysis() {
        CorrelationAnalysis a = new CorrelationAnalysis();
        a.setTitle(this.analysisDetailsPage.getAnalysisTitle());
        a.setDescription(this.analysisDetailsPage.getAnalysisNotes());
        a.setAttributes(this.analysisDetailsPage.getAnalysisAttributes());
        a.setReplaceNanValue(this.corrPage.isReplaceNanValuesEnabled() ? Double.valueOf(this.corrPage.getReplaceNanValue()) : null);
        a.setTransposeData(this.corrPage.isTransposeEnabled());
        return a;
    }

    private void setAnalysis(CorrelationAnalysis a) {
        this.analysisDetailsPage.setAnalysisTitle(a.getTitle());
        this.analysisDetailsPage.setAnalysisNotes(a.getDescription());
        this.analysisDetailsPage.setAnalysisAttributes(a.getAttributes());
        this.corrPage.setReplaceNanValuesEnabled(a.getReplaceNanValue() != null);
        if (a.getReplaceNanValue() != null) {
            this.corrPage.setReplaceNanValue(a.getReplaceNanValue());
        }
        this.corrPage.setTransposeEnabled(a.isTransposeData());
    }
}

