/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.correlation.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JSplitPane;
import org.gitools.analysis.correlation.CorrelationAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.DiagonalMatrixView;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.model.decorator.impl.CorrelationElementDecorator;
import org.gitools.ui.analysis.correlation.editor.CorrelationTablesPanel;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.actions.BaseAction;

public class CorrelationResultsEditor
extends HeatmapEditor {
    protected CorrelationAnalysis analysis;
    protected AbstractTablesPanel tablesPanel;

    protected static Heatmap createHeatmap(CorrelationAnalysis analysis) {
        DiagonalMatrixView results = new DiagonalMatrixView(analysis.getResults());
        Heatmap heatmap = new Heatmap((IMatrixView)results);
        heatmap.setTitle(analysis.getTitle() + " (results)");
        IElementAdapter cellAdapter = results.getCellAdapter();
        int propertiesNb = cellAdapter.getProperties().size();
        CorrelationElementDecorator[] dec = new CorrelationElementDecorator[propertiesNb];
        for (int i = 0; i < propertiesNb; ++i) {
            dec[i] = new CorrelationElementDecorator(cellAdapter);
            int valueIndex = cellAdapter.getPropertyIndex("score");
            dec[i].setValueIndex(valueIndex != -1 ? valueIndex : 0);
        }
        heatmap.setCellDecorators((ElementDecorator[])dec);
        heatmap.setTitle(analysis.getTitle());
        return heatmap;
    }

    protected static List<BaseAction> createToolBar(CorrelationAnalysis analysis) {
        return null;
    }

    public CorrelationResultsEditor(CorrelationAnalysis analysis) {
        super(CorrelationResultsEditor.createHeatmap(analysis), CorrelationResultsEditor.createToolBar(analysis), true);
        this.tablesPanel = new CorrelationTablesPanel(analysis, this.heatmap);
        this.tablesPanel.setMinimumSize(new Dimension(140, 140));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setTopComponent(this.embeddedContainer);
        splitPane.setBottomComponent(this.tablesPanel);
        this.setLayout(new BorderLayout());
        this.add(splitPane);
    }
}

