/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.correlation.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.correlation.CorrelationAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.correlation.editor.CorrelationResultsEditor;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class CorrelationAnalysisEditor
extends AnalysisDetailsEditor<CorrelationAnalysis> {
    public CorrelationAnalysisEditor(CorrelationAnalysis analysis) {
        super(analysis, "/vm/analysis/correlation/analysis_details.vm", null);
    }

    @Override
    protected void prepareContext(VelocityContext context) {
        PersistenceManager.FileRef fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((CorrelationAnalysis)this.analysis).getData());
        context.put("dataFile", (Object)(fileRef != null ? fileRef.getFile().getName() : "Not defined"));
        String appliedTo = ((CorrelationAnalysis)this.analysis).isTransposeData() ? "rows" : "columns";
        context.put("appliedTo", (Object)appliedTo);
        if (((CorrelationAnalysis)this.analysis).getMethod().equals("pearson")) {
            context.put("method", (Object)"Pearson's correlation");
        }
    }

    @Override
    protected void performUrlAction(String name, Map<String, String> params) {
        if ("NewDataHeatmap".equals(name)) {
            this.newDataHeatmap();
        } else if ("NewResultsHeatmap".equals(name)) {
            this.newResultsHeatmap();
        }
    }

    private void newDataHeatmap() {
        if (((CorrelationAnalysis)this.analysis).getData() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain data.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from data ...", 1);
                MatrixView dataTable = new MatrixView(((CorrelationAnalysis)CorrelationAnalysisEditor.this.analysis).getData());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((CorrelationAnalysis)CorrelationAnalysisEditor.this.analysis).getTitle() + " (data)");
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(CorrelationAnalysisEditor.this.getName(), "correlations", "-data", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("New heatmap created.");
                    }
                });
            }
        });
    }

    private void newResultsHeatmap() {
        if (((CorrelationAnalysis)this.analysis).getResults() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain results.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from results ...", 1);
                MatrixView dataTable = new MatrixView(((CorrelationAnalysis)CorrelationAnalysisEditor.this.analysis).getResults());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((CorrelationAnalysis)CorrelationAnalysisEditor.this.analysis).getTitle() + " (results)");
                final CorrelationResultsEditor editor = new CorrelationResultsEditor((CorrelationAnalysis)CorrelationAnalysisEditor.this.analysis);
                editor.setName(editorPanel.deriveName(CorrelationAnalysisEditor.this.getName(), "correlations", "-results", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("Heatmap for correlation results created.");
                    }
                });
            }
        });
    }
}

