/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.combination.wizard;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.IEntityPersistence;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.combination.wizard.CombinationAnalysisParamsPage;
import org.gitools.ui.analysis.wizard.AnalysisDetailsPage;
import org.gitools.ui.analysis.wizard.DataFilePage;
import org.gitools.ui.analysis.wizard.ExamplePage;
import org.gitools.ui.analysis.wizard.SelectFilePage;
import org.gitools.ui.examples.ExamplesManager;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.dialog.MessageStatus;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.AbstractWizard;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFilePage;

public class CombinationAnalysisWizard
extends AbstractWizard {
    private static final String EXAMPLE_ANALYSIS_FILE = "analysis.combination";
    private static final String EXAMPLE_DATA_FILE = "19_lung_10_breast_upreg_annot.cdm.gz";
    private static final String EXAMPLE_COLUM_SETS_FILE = "lung_breast_experiments_annotated.tcm";
    private static final FileFormat[] dataFormats = new FileFormat[]{FileFormats.RESULTS_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.MODULES_2C_MAP, FileFormats.MODULES_INDEXED_MAP};
    private static final FileFormat[] columnSetsFormats = new FileFormat[]{FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.MODULES_2C_MAP, FileFormats.MODULES_INDEXED_MAP};
    private ExamplePage examplePage;
    private DataFilePage dataPage;
    private CombinationAnalysisParamsPage combinationParamsPage;
    private SelectFilePage columnSetsPage;
    private SaveFilePage saveFilePage;
    private AnalysisDetailsPage analysisDetailsPage;
    private boolean examplePageEnabled = true;
    private boolean dataFromMemory = false;
    private List<IElementAttribute> attributes;
    private boolean saveFilePageEnabled = true;
    private File dataFile;

    public CombinationAnalysisWizard() {
        this.setTitle("Combination analysis");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Combination.png", (int)96));
        this.setHelpContext("analysis_combination");
    }

    public void addPages() {
        if (this.examplePageEnabled && Settings.getDefault().isShowCombinationExamplePage()) {
            this.examplePage = new ExamplePage("a combination analysis");
            this.examplePage.setTitle("Combination analysis");
            this.addPage((IWizardPage)this.examplePage);
        }
        if (!this.dataFromMemory) {
            this.dataPage = new DataFilePage(dataFormats);
            this.addPage((IWizardPage)this.dataPage);
        }
        this.combinationParamsPage = new CombinationAnalysisParamsPage();
        this.combinationParamsPage.setAttributes(this.attributes);
        this.addPage((IWizardPage)this.combinationParamsPage);
        this.columnSetsPage = new SelectFilePage(columnSetsFormats){

            @Override
            protected String getLastPath() {
                return Settings.getDefault().getLastMapPath();
            }

            @Override
            protected void setLastPath(String path) {
                Settings.getDefault().setLastMapPath(path);
            }
        };
        this.columnSetsPage.setTitle("Select sets of columns/rows to combine");
        this.columnSetsPage.setMessage(MessageStatus.INFO, "Leave blank to combine all the columns");
        this.columnSetsPage.setBlankFileAllowed(true);
        this.addPage((IWizardPage)this.columnSetsPage);
        if (this.saveFilePageEnabled) {
            this.saveFilePage = new SaveFilePage();
            this.saveFilePage.setTitle("Select destination file");
            this.saveFilePage.setFolder(Settings.getDefault().getLastWorkPath());
            this.saveFilePage.setFormats(new FileFormat[]{FileFormats.COMBINATION});
            this.saveFilePage.setFormatsVisible(false);
            this.addPage((IWizardPage)this.saveFilePage);
        }
        this.analysisDetailsPage = new AnalysisDetailsPage();
        this.addPage((IWizardPage)this.analysisDetailsPage);
    }

    public void pageEntered(IWizardPage page) {
        if (!(!((Object)((Object)this.combinationParamsPage)).equals(page) || this.dataFromMemory || this.dataFile != null && this.dataPage.getFile().equals(this.dataFile))) {
            JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                public void run(IProgressMonitor monitor) {
                    monitor.begin("Reading data header ...", 1);
                    String mimeType = CombinationAnalysisWizard.this.dataPage.getFileFormat().getMime();
                    IEntityPersistence ep = PersistenceManager.getDefault().createEntityPersistence(mimeType, new Properties());
                    Map meta = null;
                    try {
                        meta = ep.readMetadata(CombinationAnalysisWizard.this.dataPage.getFile(), new String[]{"attributes"}, monitor);
                        if (meta != null) {
                            CombinationAnalysisWizard.this.attributes = (List)meta.get("attributes");
                            CombinationAnalysisWizard.this.combinationParamsPage.setAttributes(CombinationAnalysisWizard.this.attributes);
                            CombinationAnalysisWizard.this.dataFile = CombinationAnalysisWizard.this.dataPage.getFile();
                        }
                    }
                    catch (Exception ex) {
                        monitor.exception(ex);
                    }
                    monitor.end();
                }
            });
        }
    }

    public void pageLeft(IWizardPage currentPage) {
        if (currentPage == this.examplePage) {
            Settings.getDefault().setShowCombinationExamplePage(this.examplePage.isShowAgain());
            if (this.examplePage.isExampleEnabled()) {
                JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                    public void run(IProgressMonitor monitor) {
                        final File basePath = ExamplesManager.getDefault().resolvePath("combination", monitor);
                        if (basePath == null) {
                            throw new RuntimeException("Unexpected error: There are no examples available");
                        }
                        File analysisFile = new File(basePath, CombinationAnalysisWizard.EXAMPLE_ANALYSIS_FILE);
                        Properties props = new Properties();
                        props.setProperty("load_references", "false");
                        try {
                            final CombinationAnalysis a = (CombinationAnalysis)PersistenceManager.getDefault().load(analysisFile, props, monitor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CombinationAnalysisWizard.this.setAnalysis(a);
                                    CombinationAnalysisWizard.this.dataPage.setFile(new File(basePath, CombinationAnalysisWizard.EXAMPLE_DATA_FILE));
                                    CombinationAnalysisWizard.this.columnSetsPage.setFile(new File(basePath, CombinationAnalysisWizard.EXAMPLE_COLUM_SETS_FILE));
                                    CombinationAnalysisWizard.this.saveFilePage.setFileNameWithoutExtension("example");
                                }
                            });
                        }
                        catch (Exception ex) {
                            monitor.exception(ex);
                        }
                    }
                });
            }
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getCurrentPage();
        boolean canFinish = super.canFinish();
        return canFinish |= page == this.saveFilePage && page.isComplete();
    }

    public boolean isExamplePageEnabled() {
        return this.examplePageEnabled;
    }

    public void setExamplePageEnabled(boolean examplePageEnabled) {
        this.examplePageEnabled = examplePageEnabled;
    }

    public boolean isDataFromMemory() {
        return this.dataFromMemory;
    }

    public void setDataFromMemory(boolean dataFromMemory) {
        this.dataFromMemory = dataFromMemory;
    }

    public List<IElementAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<IElementAttribute> attributes) {
        this.attributes = attributes;
    }

    public boolean isSaveFilePageEnabled() {
        return this.saveFilePageEnabled;
    }

    public void setSaveFilePageEnabled(boolean saveFilePageEnabled) {
        this.saveFilePageEnabled = saveFilePageEnabled;
    }

    public CombinationAnalysis getAnalysis() {
        CombinationAnalysis a = new CombinationAnalysis();
        a.setTitle(this.analysisDetailsPage.getAnalysisTitle());
        a.setDescription(this.analysisDetailsPage.getAnalysisNotes());
        a.setAttributes(this.analysisDetailsPage.getAnalysisAttributes());
        IElementAttribute attr = this.combinationParamsPage.getSizeAttribute();
        String sizeAttrName = attr != null ? attr.getId() : null;
        a.setSizeAttrName(sizeAttrName);
        attr = this.combinationParamsPage.getPvalueAttribute();
        String pvalueAttrName = attr != null ? attr.getId() : null;
        a.setPvalueAttrName(pvalueAttrName);
        a.setTransposeData(this.combinationParamsPage.isTransposeEnabled());
        return a;
    }

    private void setAnalysis(CombinationAnalysis a) {
        this.analysisDetailsPage.setAnalysisTitle(a.getTitle());
        this.analysisDetailsPage.setAnalysisNotes(a.getDescription());
        this.analysisDetailsPage.setAnalysisAttributes(a.getAttributes());
        this.combinationParamsPage.setPreferredSizeAttr(a.getSizeAttrName());
        this.combinationParamsPage.setPreferredPvalueAttr(a.getPvalueAttrName());
        this.combinationParamsPage.setTransposeEnabled(a.isTransposeData());
    }

    public DataFilePage getDataFilePage() {
        return this.dataPage;
    }

    public CombinationAnalysisParamsPage getCombinationParamsPage() {
        return this.combinationParamsPage;
    }

    public SelectFilePage getColumnSetsPage() {
        return this.columnSetsPage;
    }

    public SaveFilePage getSaveFilePage() {
        return this.saveFilePage;
    }
}

