/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.combination.wizard;

import java.awt.Container;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

public class CombinationAnalysisParamsPage
extends AbstractWizardPage {
    private List<IElementAttribute> attrs;
    private String preferredSizeAttr;
    private String preferredPvalueAttr;
    private ButtonGroup applyButtonGroup;
    private JRadioButton applyToColumnsRb;
    private JRadioButton applyToRowsRb;
    private JLabel jLabel2;
    private JComboBox pvalueAttrCb;
    private JLabel pvalueAttrLabel;
    private JComboBox sizeAttrCb;
    private JLabel sizeAttrLabel;

    public CombinationAnalysisParamsPage() {
        this.initComponents();
        this.dissableAttrCb();
        this.setTitle("Configure combination options");
        this.setLogo(IconUtils.getImageIconResourceScaledByHeight((String)"/img/logos/Method.png", (int)96));
        this.setComplete(true);
    }

    private void dissableAttrCb() {
        this.sizeAttrCb.setModel(new DefaultComboBoxModel());
        this.sizeAttrLabel.setEnabled(false);
        this.sizeAttrCb.setEnabled(false);
        this.pvalueAttrCb.setModel(new DefaultComboBoxModel());
        this.pvalueAttrLabel.setEnabled(false);
        this.pvalueAttrCb.setEnabled(false);
    }

    public void setAttributes(List<IElementAttribute> attrs) {
        this.attrs = attrs;
        if (attrs != null) {
            AttrOption[] sizeAttrs = new AttrOption[attrs.size() + 1];
            sizeAttrs[0] = new AttrOption("All columns with the same weight");
            for (int i = 0; i < attrs.size(); ++i) {
                sizeAttrs[i + 1] = new AttrOption(attrs.get(i));
            }
            this.sizeAttrCb.setModel(new DefaultComboBoxModel<AttrOption>(sizeAttrs));
            AttrOption[] pvalueAttrs = new AttrOption[attrs.size()];
            for (int i = 0; i < attrs.size(); ++i) {
                pvalueAttrs[i] = new AttrOption(attrs.get(i));
            }
            this.pvalueAttrCb.setModel(new DefaultComboBoxModel<AttrOption>(pvalueAttrs));
            int sizeIndex = -1;
            int pvalueIndex = -1;
            int i = 0;
            for (IElementAttribute a : attrs) {
                String aid = a.getId();
                if (sizeIndex == -1 && (aid.equals(this.preferredSizeAttr) || aid.matches("^(n|N)$"))) {
                    sizeIndex = i;
                }
                if (pvalueIndex == -1 && (aid.equals(this.preferredPvalueAttr) || aid.matches("^(right-|.*)p-value$"))) {
                    pvalueIndex = i;
                }
                ++i;
            }
            sizeIndex = sizeIndex == -1 ? 0 : sizeIndex + 1;
            pvalueIndex = pvalueIndex == -1 ? 0 : pvalueIndex + 1;
            this.sizeAttrCb.setSelectedIndex(sizeIndex);
            this.pvalueAttrCb.setSelectedIndex(pvalueIndex);
            this.sizeAttrLabel.setEnabled(true);
            this.sizeAttrCb.setEnabled(true);
            this.pvalueAttrLabel.setEnabled(true);
            this.pvalueAttrCb.setEnabled(true);
        } else {
            this.dissableAttrCb();
        }
    }

    public void setPreferredSizeAttr(String preferredSizeAttr) {
        this.preferredSizeAttr = preferredSizeAttr;
    }

    public void setPreferredPvalueAttr(String preferredPvalueAttr) {
        this.preferredPvalueAttr = preferredPvalueAttr;
    }

    public IElementAttribute getSizeAttribute() {
        AttrOption option = (AttrOption)this.sizeAttrCb.getSelectedItem();
        return option != null ? option.getAttr() : null;
    }

    public IElementAttribute getPvalueAttribute() {
        AttrOption option = (AttrOption)this.pvalueAttrCb.getSelectedItem();
        return option != null ? option.getAttr() : null;
    }

    public boolean isTransposeEnabled() {
        return this.applyToRowsRb.isSelected();
    }

    public void setTransposeEnabled(boolean transpose) {
        this.applyToColumnsRb.setSelected(!transpose);
    }

    private void initComponents() {
        this.applyButtonGroup = new ButtonGroup();
        this.sizeAttrLabel = new JLabel();
        this.sizeAttrCb = new JComboBox();
        this.jLabel2 = new JLabel();
        this.applyToColumnsRb = new JRadioButton();
        this.applyToRowsRb = new JRadioButton();
        this.pvalueAttrLabel = new JLabel();
        this.pvalueAttrCb = new JComboBox();
        this.sizeAttrLabel.setText("Size attribute");
        this.jLabel2.setText("Apply to:");
        this.applyButtonGroup.add(this.applyToColumnsRb);
        this.applyToColumnsRb.setSelected(true);
        this.applyToColumnsRb.setText("Columns");
        this.applyButtonGroup.add(this.applyToRowsRb);
        this.applyToRowsRb.setText("Rows");
        this.pvalueAttrLabel.setText("P-value attribute");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sizeAttrLabel, -1, -1, Short.MAX_VALUE).addComponent(this.pvalueAttrLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sizeAttrCb, 0, 304, Short.MAX_VALUE).addComponent(this.pvalueAttrCb, GroupLayout.Alignment.LEADING, 0, 304, Short.MAX_VALUE))).addComponent(this.jLabel2).addComponent(this.applyToColumnsRb).addComponent(this.applyToRowsRb)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeAttrLabel).addComponent(this.sizeAttrCb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pvalueAttrLabel).addComponent(this.pvalueAttrCb, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyToColumnsRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyToRowsRb).addContainerGap(125, Short.MAX_VALUE)));
    }

    private static class AttrOption {
        private String name;
        private IElementAttribute attr;

        public AttrOption(String name) {
            this.name = name;
        }

        public AttrOption(IElementAttribute attr) {
            this.attr = attr;
        }

        public IElementAttribute getAttr() {
            return this.attr;
        }

        public String toString() {
            return this.attr != null ? this.attr.getName() : this.name;
        }
    }
}

