/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.combination.editor;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.colorscale.impl.ZScoreColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.model.ModuleMap;
import org.gitools.ui.analysis.editor.AbstractTablesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationTablesPanel
extends AbstractTablesPanel<CombinationAnalysis> {
    private static Logger log = LoggerFactory.getLogger(CombinationTablesPanel.class);
    private static final String DATA_TEMPLATE = "/vm/analysis/combination/tables_data.vm";
    private static final String RESULTS_TEMPLATE = "/vm/analysis/combination/tables_results.vm";
    protected Map<String, Integer> dataRowIndices;
    protected Map<String, Integer> dataColIndices;
    protected ModuleMap gmap;

    public CombinationTablesPanel(CombinationAnalysis analysis, Heatmap heatmap) {
        super(analysis, heatmap);
        int i;
        IMatrix data = analysis.getData();
        int numRows = data.getRowCount();
        int numCols = data.getColumnCount();
        this.dataRowIndices = new HashMap<String, Integer>();
        for (i = 0; i < numRows; ++i) {
            this.dataRowIndices.put(data.getRowLabel(i), i);
        }
        this.dataColIndices = new HashMap<String, Integer>();
        for (i = 0; i < numCols; ++i) {
            this.dataColIndices.put(data.getColumnLabel(i), i);
        }
        String[] labels = new String[numCols];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            labels[i2] = data.getColumnLabel(i2);
        }
        String combOf = analysis.isTransposeData() ? "rows" : "columns";
        this.gmap = analysis.getGroupsMap();
        if (this.gmap != null) {
            this.gmap = this.gmap.remap(labels);
        } else {
            int i3;
            IMatrixView mv = heatmap.getMatrixView();
            String[] groups = new String[mv.getColumnCount()];
            for (int i4 = 0; i4 < groups.length; ++i4) {
                groups[i4] = mv.getColumnLabel(i4);
            }
            this.gmap = new ModuleMap();
            this.gmap.setModuleNames(groups);
            this.gmap.setItemNames(labels);
            int[] indices = new int[numCols];
            for (i3 = 0; i3 < indices.length; ++i3) {
                indices[i3] = i3;
            }
            for (i3 = 0; i3 < groups.length; ++i3) {
                this.gmap.setItemIndices(i3, indices);
            }
        }
    }

    @Override
    protected VelocityContext createModel() {
        IMatrixView mv = this.heatmap.getMatrixView();
        int row = mv.getLeadSelectionRow();
        int col = mv.getLeadSelectionColumn();
        IMatrix data = ((CombinationAnalysis)this.analysis).getData();
        String template = DATA_TEMPLATE;
        VelocityContext context = new VelocityContext();
        switch (this.viewMode) {
            case 1: {
                template = DATA_TEMPLATE;
                if (row != -1 && col != -1) {
                    context.put("columns", this.createDataCellModel(mv, row, col, data, this.gmap));
                    break;
                }
                if (row == -1 && col != -1) {
                    context.put("columns", this.createDataColumnModel(mv, col, data, this.gmap));
                    break;
                }
                if (row != -1 && col == -1) {
                    context.put("columns", this.createDataRowModel(mv, row, data, this.gmap));
                    break;
                }
                context.put("columns", this.createDataAllModel(mv, data, this.gmap));
                break;
            }
            case 2: {
                template = RESULTS_TEMPLATE;
                if (row != -1 && col != -1) {
                    context.put("columns", this.createResultsCellModel(mv, row, col));
                    break;
                }
                if (row == -1 && col != -1) {
                    context.put("columns", this.createResultsColumnModel(mv, col));
                    break;
                }
                if (row != -1 && col == -1) {
                    context.put("columns", this.createResultsRowModel(mv, row));
                    break;
                }
                context.put("columns", this.createResultsAllModel(mv));
            }
        }
        context.put("__template__", (Object)template);
        return context;
    }

    private List<VelocityContext> createDataElements(IMatrixView mv, int row, int col, IMatrix data, ModuleMap gmap) {
        int[] cindices;
        int sizeIndex = -1;
        String sizeAttrName = ((CombinationAnalysis)this.analysis).getSizeAttrName();
        if (sizeAttrName != null && !sizeAttrName.isEmpty()) {
            sizeIndex = data.getCellAdapter().getPropertyIndex(sizeAttrName);
        }
        int pvalueIndex = 0;
        String pvalueAttrName = ((CombinationAnalysis)this.analysis).getPvalueAttrName();
        if (pvalueAttrName != null && !pvalueAttrName.isEmpty()) {
            pvalueIndex = data.getCellAdapter().getPropertyIndex(pvalueAttrName);
        }
        MatrixUtils.DoubleCast sizeCast = null;
        if (sizeIndex >= 0) {
            sizeCast = MatrixUtils.createDoubleCast((Class)data.getCellAdapter().getProperty(sizeIndex).getValueClass());
        }
        MatrixUtils.DoubleCast pvalueCast = MatrixUtils.createDoubleCast((Class)data.getCellAdapter().getProperty(pvalueIndex).getValueClass());
        ArrayList<VelocityContext> elements = new ArrayList<VelocityContext>();
        int numCols = data.getColumnCount();
        String gname = mv.getColumnLabel(col);
        int[] nArray = cindices = gmap != null ? gmap.getItemIndices(gname) : new int[numCols];
        if (gmap == null) {
            for (int i = 0; i < numCols; ++i) {
                cindices[i] = i;
            }
        }
        GenericFormatter fmt = new GenericFormatter();
        PValueColorScale scale = new PValueColorScale();
        int drow = this.dataRowIndices.get(mv.getRowLabel(row));
        double sumSize = 0.0;
        for (int ci = 0; ci < cindices.length; ++ci) {
            int mci = cindices[ci];
            if (data.getCell(drow, mci) == null) continue;
            double size = sizeIndex < 0 ? 1.0 : sizeCast.getDoubleValue(data.getCellValue(drow, mci, sizeIndex));
            sumSize += size;
            double pvalue = pvalueCast.getDoubleValue(data.getCellValue(drow, mci, pvalueIndex));
            VelocityContext e = new VelocityContext();
            e.put("name", (Object)data.getColumnLabel(mci));
            e.put("n", (Object)((int)size));
            e.put("pvalue", (Object)fmt.pvalue(pvalue));
            e.put("pvalue_color", (Object)ColorUtils.colorToRGBHtml(scale.valueColor(pvalue)));
            elements.add(e);
        }
        for (VelocityContext e : elements) {
            e.put("weight", (Object)fmt.format((double)((Integer)e.get("n")).intValue() / sumSize));
        }
        return elements;
    }

    private VelocityContext createDataElementsCombination(IMatrixView mv, int row, int col, IMatrix data, ModuleMap gmap) {
        GenericFormatter fmt = new GenericFormatter();
        List<VelocityContext> elements = this.createDataElements(mv, row, col, data, gmap);
        int n = MatrixUtils.intValue((Object)mv.getCellValue(row, col, "N"));
        double pvalue = MatrixUtils.doubleValue((Object)mv.getCellValue(row, col, "p-value"));
        PValueColorScale scale = new PValueColorScale();
        VelocityContext combination = new VelocityContext();
        combination.put("name", (Object)mv.getRowLabel(row));
        combination.put("n", (Object)n);
        combination.put("pvalue", (Object)fmt.pvalue(pvalue));
        combination.put("pvalue_color", (Object)ColorUtils.colorToRGBHtml(scale.valueColor(pvalue)));
        combination.put("elements", elements);
        return combination;
    }

    private List<VelocityContext> createDataCellModel(IMatrixView mv, int row, int col, IMatrix data, ModuleMap gmap) {
        VelocityContext combination = this.createDataElementsCombination(mv, row, col, data, gmap);
        ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
        combinations.add(combination);
        VelocityContext column = new VelocityContext();
        column.put("name", (Object)mv.getColumnLabel(col));
        column.put("combinations", combinations);
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        columns.add(column);
        return columns;
    }

    private List<VelocityContext> createDataColumnModel(IMatrixView mv, int col, IMatrix data, ModuleMap gmap) {
        ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
        for (int ri = 0; ri < mv.getRowCount(); ++ri) {
            VelocityContext combination = this.createDataElementsCombination(mv, ri, col, data, gmap);
            combinations.add(combination);
        }
        VelocityContext column = new VelocityContext();
        column.put("name", (Object)mv.getColumnLabel(col));
        column.put("combinations", combinations);
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        columns.add(column);
        return columns;
    }

    private List<VelocityContext> createDataRowModel(IMatrixView mv, int row, IMatrix data, ModuleMap gmap) {
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            VelocityContext combination = this.createDataElementsCombination(mv, row, ci, data, gmap);
            ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
            combinations.add(combination);
            VelocityContext column = new VelocityContext();
            column.put("name", (Object)mv.getColumnLabel(ci));
            column.put("combinations", combinations);
            columns.add(column);
        }
        return columns;
    }

    private List<VelocityContext> createDataAllModel(IMatrixView mv, IMatrix data, ModuleMap gmap) {
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
            for (int ri = 0; ri < mv.getRowCount(); ++ri) {
                VelocityContext combination = this.createDataElementsCombination(mv, ri, ci, data, gmap);
                combinations.add(combination);
            }
            VelocityContext column = new VelocityContext();
            column.put("name", (Object)mv.getColumnLabel(ci));
            column.put("combinations", combinations);
            columns.add(column);
        }
        return columns;
    }

    private VelocityContext createResultsCombinationModel(IMatrixView mv, int row, int col) {
        GenericFormatter fmt = new GenericFormatter();
        int n = MatrixUtils.intValue((Object)mv.getCellValue(row, col, "n"));
        double zscore = MatrixUtils.doubleValue((Object)mv.getCellValue(row, col, "z-score"));
        double pvalue = MatrixUtils.doubleValue((Object)mv.getCellValue(row, col, "p-value"));
        PValueColorScale pscale = new PValueColorScale();
        ZScoreColorScale zscale = new ZScoreColorScale();
        VelocityContext combination = new VelocityContext();
        combination.put("n", (Object)n);
        combination.put("zscore", (Object)fmt.format(zscore));
        combination.put("zscore_color", (Object)ColorUtils.colorToRGBHtml(zscale.valueColor(zscore)));
        combination.put("pvalue", (Object)fmt.pvalue(pvalue));
        combination.put("pvalue_color", (Object)ColorUtils.colorToRGBHtml(pscale.valueColor(pvalue)));
        return combination;
    }

    private List<VelocityContext> createResultsCellModel(IMatrixView mv, int row, int col) {
        ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
        VelocityContext combination = this.createResultsCombinationModel(mv, row, col);
        combination.put("name", (Object)mv.getRowLabel(row));
        combinations.add(combination);
        VelocityContext column = new VelocityContext();
        column.put("name", (Object)mv.getColumnLabel(col));
        column.put("combinations", combinations);
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        columns.add(column);
        return columns;
    }

    private List<VelocityContext> createResultsColumnModel(IMatrixView mv, int col) {
        ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
        for (int ri = 0; ri < mv.getRowCount(); ++ri) {
            VelocityContext combination = this.createResultsCombinationModel(mv, ri, col);
            combination.put("name", (Object)mv.getRowLabel(ri));
            combinations.add(combination);
        }
        VelocityContext column = new VelocityContext();
        column.put("name", (Object)mv.getColumnLabel(col));
        column.put("combinations", combinations);
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        columns.add(column);
        return columns;
    }

    private List<VelocityContext> createResultsRowModel(IMatrixView mv, int row) {
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
            VelocityContext combination = this.createResultsCombinationModel(mv, row, ci);
            combination.put("name", (Object)mv.getColumnLabel(ci));
            combinations.add(combination);
            VelocityContext column = new VelocityContext();
            column.put("name", (Object)mv.getRowLabel(ci));
            column.put("combinations", combinations);
            columns.add(column);
        }
        return columns;
    }

    private List<VelocityContext> createResultsAllModel(IMatrixView mv) {
        ArrayList<VelocityContext> columns = new ArrayList<VelocityContext>();
        for (int ci = 0; ci < mv.getColumnCount(); ++ci) {
            ArrayList<VelocityContext> combinations = new ArrayList<VelocityContext>();
            for (int ri = 0; ri < mv.getRowCount(); ++ri) {
                VelocityContext combination = this.createResultsCombinationModel(mv, ri, ci);
                combination.put("name", (Object)mv.getRowLabel(ri));
                combinations.add(combination);
            }
            VelocityContext column = new VelocityContext();
            column.put("name", (Object)mv.getColumnLabel(ci));
            column.put("combinations", combinations);
            columns.add(column);
        }
        return columns;
    }
}

