/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.combination.editor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.ui.analysis.combination.editor.CombinationTablesPanel;
import org.gitools.ui.heatmap.editor.HeatmapEditor;

public class CombinationResultsEditor
extends HeatmapEditor {
    protected CombinationAnalysis analysis;
    protected CombinationTablesPanel tablesPanel;

    protected static Heatmap createHeatmap(CombinationAnalysis analysis) {
        MatrixView dataTable = new MatrixView(analysis.getResults());
        Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
        heatmap.setTitle(analysis.getTitle() + " (results)");
        return heatmap;
    }

    public CombinationResultsEditor(CombinationAnalysis analysis) {
        super(CombinationResultsEditor.createHeatmap(analysis), true);
        this.tablesPanel = new CombinationTablesPanel(analysis, this.heatmap);
        this.tablesPanel.setMinimumSize(new Dimension(140, 140));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setTopComponent(this.embeddedContainer);
        splitPane.setBottomComponent(this.tablesPanel);
        this.setLayout(new BorderLayout());
        this.add(splitPane);
    }
}

