/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.analysis.combination.editor;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.velocity.VelocityContext;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.util.HeatmapUtil;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.combination.editor.CombinationResultsEditor;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.dialog.UnimplementedDialog;
import org.gitools.ui.heatmap.editor.HeatmapEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class CombinationAnalysisEditor
extends AnalysisDetailsEditor<CombinationAnalysis> {
    public CombinationAnalysisEditor(CombinationAnalysis analysis) {
        super(analysis, "/vm/analysis/combination/analysis_details.vm", null);
    }

    @Override
    protected void prepareContext(VelocityContext context) {
        List attrs;
        String combOf = "columns";
        if (((CombinationAnalysis)this.analysis).isTransposeData()) {
            combOf = "rows";
        }
        context.put("combinationOf", (Object)combOf);
        PersistenceManager.FileRef fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((CombinationAnalysis)this.analysis).getData());
        context.put("dataFile", (Object)(fileRef != null ? fileRef.getFile().getName() : "Not defined"));
        fileRef = PersistenceManager.getDefault().getEntityFileRef((Object)((CombinationAnalysis)this.analysis).getGroupsMap());
        String groupsFile = fileRef != null ? fileRef.getFile().getName() : "Not specified. All " + combOf + " are combined";
        context.put("groupsFile", (Object)groupsFile);
        String sizeAttr = ((CombinationAnalysis)this.analysis).getSizeAttrName();
        if (sizeAttr == null || sizeAttr.isEmpty()) {
            sizeAttr = "Constant value of 1";
        }
        context.put("sizeAttr", (Object)sizeAttr);
        String pvalueAttr = ((CombinationAnalysis)this.analysis).getPvalueAttrName();
        if ((pvalueAttr == null || pvalueAttr.isEmpty()) && (attrs = ((CombinationAnalysis)this.analysis).getData().getCellAttributes()).size() > 0) {
            pvalueAttr = ((IElementAttribute)attrs.get(0)).getName();
        }
        context.put("pvalueAttr", (Object)pvalueAttr);
    }

    @Override
    protected void performUrlAction(String name, Map<String, String> params) {
        if ("NewDataHeatmap".equals(name)) {
            this.newDataHeatmap();
        } else if ("ViewModuleMap".equals(name)) {
            this.viewModuleMap();
        } else if ("NewResultsHeatmap".equals(name)) {
            this.newResultsHeatmap();
        }
    }

    private void newDataHeatmap() {
        if (((CombinationAnalysis)this.analysis).getData() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain data.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from data ...", 1);
                MatrixView dataTable = new MatrixView(((CombinationAnalysis)CombinationAnalysisEditor.this.analysis).getData());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((CombinationAnalysis)CombinationAnalysisEditor.this.analysis).getTitle() + " (data)");
                final HeatmapEditor editor = new HeatmapEditor(heatmap);
                editor.setName(editorPanel.deriveName(CombinationAnalysisEditor.this.getName(), "combination", "-data", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("New heatmap created.");
                    }
                });
            }
        });
    }

    private void viewModuleMap() {
        UnimplementedDialog.show(AppFrame.instance());
    }

    private void newResultsHeatmap() {
        if (((CombinationAnalysis)this.analysis).getResults() == null) {
            AppFrame.instance().setStatusText("Analysis doesn't contain results.");
            return;
        }
        final EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Creating new heatmap from results ...", 1);
                MatrixView dataTable = new MatrixView(((CombinationAnalysis)CombinationAnalysisEditor.this.analysis).getResults());
                Heatmap heatmap = HeatmapUtil.createFromMatrixView((IMatrixView)dataTable);
                heatmap.setTitle(((CombinationAnalysis)CombinationAnalysisEditor.this.analysis).getTitle() + " (results)");
                final CombinationResultsEditor editor = new CombinationResultsEditor((CombinationAnalysis)CombinationAnalysisEditor.this.analysis);
                editor.setName(editorPanel.deriveName(CombinationAnalysisEditor.this.getName(), "combination", "-results", "heatmap"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorPanel.addEditor((AbstractEditor)editor);
                        AppFrame.instance().setStatusText("Heatmap for combination results created.");
                    }
                });
            }
        });
    }
}

