/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.ui.commands.CommandLoadFile;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.FileChooserUtils;
import org.gitools.ui.utils.FileFormatFilter;

public class OpenHeatmapAction
extends BaseAction {
    private static final long serialVersionUID = -6528634034161710370L;

    public OpenHeatmapAction() {
        super("Heatmap ...");
        this.setDesc("Open a heatmap from a file");
        this.setSmallIconFromResource("/img/OpenMatrix16.gif");
        this.setLargeIconFromResource("/img/OpenMatrix24.gif");
        this.setMnemonic(77);
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        FileFilter[] filters = new FileFilter[]{new FileFormatFilter("Known formats", null, new FileFormat[]{FileFormats.RESULTS_MATRIX, FileFormats.DOUBLE_MATRIX, FileFormats.DOUBLE_BINARY_MATRIX, FileFormats.GENE_MATRIX, FileFormats.GENE_MATRIX_TRANSPOSED}), new FileFormatFilter(FileFormats.RESULTS_MATRIX), new FileFormatFilter(FileFormats.RESULTS_MATRIX.getTitle() + " (*.*)", "application/gitools-matrix-object"), new FileFormatFilter(FileFormats.DOUBLE_MATRIX), new FileFormatFilter(FileFormats.DOUBLE_MATRIX.getTitle() + " (*.*)", "application/gitools-matrix-double"), new FileFormatFilter(FileFormats.DOUBLE_BINARY_MATRIX), new FileFormatFilter(FileFormats.GENE_MATRIX), new FileFormatFilter(FileFormats.GENE_MATRIX_TRANSPOSED)};
        FileChooserUtils.FileAndFilter ret = FileChooserUtils.selectFile("Select file", 2, filters);
        if (ret == null) {
            return;
        }
        File file = ret.getFile();
        if (file == null) {
            return;
        }
        FileFormatFilter ff = (FileFormatFilter)ret.getFilter();
        Settings.getDefault().setLastPath(file.getParent());
        Settings.getDefault().save();
        CommandLoadFile loadFile = new CommandLoadFile(file.getAbsolutePath(), ff.getMime());
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)loadFile);
        AppFrame.instance().setStatusText("Done.");
    }
}

