/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.analysis.correlation.CorrelationAnalysis;
import org.gitools.analysis.htest.enrichment.EnrichmentAnalysis;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.model.Analysis;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceManager;
import org.gitools.ui.analysis.combination.editor.CombinationAnalysisEditor;
import org.gitools.ui.analysis.correlation.editor.CorrelationAnalysisEditor;
import org.gitools.ui.analysis.editor.AnalysisDetailsEditor;
import org.gitools.ui.analysis.htest.editor.EnrichmentAnalysisEditor;
import org.gitools.ui.analysis.htest.editor.OncodriveAnalysisEditor;
import org.gitools.ui.analysis.overlapping.OverlappingAnalysisEditor;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.FileChooserUtils;
import org.gitools.ui.utils.FileFormatFilter;

public class OpenAnalysisAction
extends BaseAction {
    private static final long serialVersionUID = -6528634034161710370L;

    public OpenAnalysisAction() {
        super("Analysis ...");
        this.setDesc("Open an analysis from the file system");
        this.setSmallIconFromResource("/img/OpenAnalysis16.gif");
        this.setLargeIconFromResource("/img/OpenAnalysis24.gif");
        this.setMnemonic(65);
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        FileFilter[] filters = new FileFilter[]{new FileFormatFilter("Any analysis", null, new FileFormat[]{FileFormats.ENRICHMENT, FileFormats.ONCODRIVE, FileFormats.CORRELATIONS, FileFormats.COMBINATION, FileFormats.OVERLAPPING}), new FileFormatFilter(FileFormats.ENRICHMENT), new FileFormatFilter(FileFormats.ONCODRIVE), new FileFormatFilter(FileFormats.CORRELATIONS), new FileFormatFilter(FileFormats.COMBINATION), new FileFormatFilter(FileFormats.OVERLAPPING)};
        FileChooserUtils.FileAndFilter ret = FileChooserUtils.selectFile("Select the analysis file", Settings.getDefault().getLastPath(), 2, filters);
        if (ret == null) {
            return;
        }
        final File file = ret.getFile();
        final FileFormatFilter filter = (FileFormatFilter)ret.getFilter();
        if (file != null) {
            Settings.getDefault().setLastPath(file.getParent());
            Settings.getDefault().save();
            JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        AnalysisDetailsEditor editor = null;
                        String mime = filter.getMime();
                        if (mime == null) {
                            mime = PersistenceManager.getDefault().getMimeFromFile(file.getName());
                        }
                        Analysis analysis = (Analysis)PersistenceManager.getDefault().load(file, mime, monitor);
                        if (monitor.isCancelled()) {
                            return;
                        }
                        if (mime.equals("application/gitools-analysis-enrichment")) {
                            editor = new EnrichmentAnalysisEditor((EnrichmentAnalysis)analysis);
                        } else if (mime.equals("application/gitools-analysis-oncodrive")) {
                            editor = new OncodriveAnalysisEditor((OncodriveAnalysis)analysis);
                        } else if (mime.equals("application/gitools-analysis-correlations")) {
                            editor = new CorrelationAnalysisEditor((CorrelationAnalysis)analysis);
                        } else if (mime.equals("application/gitools-analysis-combination")) {
                            editor = new CombinationAnalysisEditor((CombinationAnalysis)analysis);
                        } else if (mime.equals("application/gitools-analysis-overlapping")) {
                            editor = new OverlappingAnalysisEditor((OverlappingAnalysis)analysis);
                        }
                        editor.setName(file.getName());
                        final AnalysisDetailsEditor newEditor = editor;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AppFrame.instance().getEditorsPanel().addEditor(newEditor);
                                AppFrame.instance().refresh();
                            }
                        });
                    }
                    catch (Exception ex) {
                        monitor.exception(ex);
                    }
                }
            });
        }
    }
}

