/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.analysis.overlapping.OverlappingCommand;
import org.gitools.model.ResourceRef;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.analysis.overlapping.OverlappingAnalysisEditor;
import org.gitools.ui.analysis.overlapping.wizard.OverlappingAnalysisWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class NewOverlappingAnalysisAction
extends BaseAction {
    private static final long serialVersionUID = -8917512377366424724L;

    public NewOverlappingAnalysisAction() {
        super("Overlapping analysis ...");
        this.setDesc("Run an overlapping analysis");
        this.setMnemonic(76);
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        final OverlappingAnalysisWizard wizard = new OverlappingAnalysisWizard();
        WizardDialog wizDlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wizDlg.open();
        if (wizDlg.isCancelled()) {
            return;
        }
        final OverlappingAnalysis analysis = wizard.getAnalysis();
        ResourceRef sourceDataResource = new ResourceRef(wizard.getDataFilePage().getFileFormat().getMime(), wizard.getDataFilePage().getFile().getAbsolutePath());
        analysis.setSourceDataResource(sourceDataResource);
        final OverlappingCommand cmd = new OverlappingCommand(analysis, wizard.getWorkdir(), wizard.getFileName());
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    cmd.run(monitor);
                    if (monitor.isCancelled()) {
                        return;
                    }
                    final OverlappingAnalysisEditor editor = new OverlappingAnalysisEditor(analysis);
                    editor.setName(PersistenceUtils.getFileName((String)wizard.getFileName()) + "." + "heatmap");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                            AppFrame.instance().refresh();
                        }
                    });
                    monitor.end();
                    AppFrame.instance().setStatusText("Done.");
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

