/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import org.gitools.analysis.htest.oncozet.OncodriveAnalysis;
import org.gitools.analysis.htest.oncozet.OncodriveCommand;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.analysis.htest.editor.OncodriveAnalysisEditor;
import org.gitools.ui.analysis.htest.wizard.OncodriveAnalysisWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class NewOncodriveAnalysisAction
extends BaseAction {
    private static final long serialVersionUID = -8592231961109105958L;

    public NewOncodriveAnalysisAction() {
        super("OncoDrive analysis ...");
        this.setDesc("Run an oncodrive analysis");
        this.setMnemonic(79);
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        final OncodriveAnalysisWizard wizard = new OncodriveAnalysisWizard();
        WizardDialog wizDlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wizDlg.open();
        if (wizDlg.isCancelled()) {
            return;
        }
        final OncodriveAnalysis analysis = wizard.getAnalysis();
        File populationFile = wizard.getPopulationFile();
        File modulesFile = wizard.getModulesFile();
        final OncodriveCommand cmd = new OncodriveCommand(analysis, wizard.getDataFileMime(), wizard.getDataFile().getAbsolutePath(), populationFile != null ? populationFile.getAbsolutePath() : null, wizard.getPopulationDefaultValue(), wizard.getModulesFileMime(), modulesFile != null ? modulesFile.getAbsolutePath() : null, wizard.getWorkdir(), wizard.getFileName());
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    cmd.run(monitor);
                    if (monitor.isCancelled()) {
                        return;
                    }
                    final OncodriveAnalysisEditor editor = new OncodriveAnalysisEditor(analysis);
                    editor.setName(PersistenceUtils.getBaseName((String)wizard.getFileName()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                            AppFrame.instance().refresh();
                        }
                    });
                    monitor.end();
                    AppFrame.instance().setStatusText("Done.");
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

