/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;
import org.gitools.kegg.modules.EnsemblKeggModulesImporter;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.modules.importer.ModulesImporter;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.kegg.wizard.KeggModulesImportWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class ImportKeggModulesAction
extends BaseAction {
    public ImportKeggModulesAction() {
        super("KEGG Pathways ...");
        this.setLargeIconFromResource("/img/Kegg24.png");
        this.setSmallIconFromResource("/img/Kegg16.png");
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        final EnsemblKeggModulesImporter importer = new EnsemblKeggModulesImporter(true, false);
        final KeggModulesImportWizard wz = new KeggModulesImportWizard((ModulesImporter)importer);
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    ModuleMap mmap = importer.importMap(monitor);
                    if (!monitor.isCancelled()) {
                        String mime = wz.getSaveFilePage().getFormat().getMime();
                        File file = wz.getSaveFilePage().getPathAsFile();
                        if ("application/gitools-gmx".equals(mime) || "application/gitools-gmt".equals(mime)) {
                            BaseMatrix mat = MatrixUtils.moduleMapToMatrix((ModuleMap)mmap);
                            PersistenceManager.getDefault().store(file, mime, (Object)mat, monitor);
                        } else {
                            PersistenceManager.getDefault().store(file, mime, (Object)mmap, monitor);
                        }
                        String prefix = PersistenceUtils.getFileName((String)file.getName());
                        file = new File(file.getParentFile(), prefix + "_annotations.tsv");
                        monitor.begin("Saving module annotations ...", mmap.getModuleCount());
                        PrintWriter pw = new PrintWriter(file);
                        pw.println("id\tname");
                        for (int i = 0; i < mmap.getModuleCount(); ++i) {
                            pw.print(mmap.getModuleName(i));
                            pw.print('\t');
                            pw.println(mmap.getModuleDescription(i));
                            monitor.worked(1);
                        }
                        pw.close();
                        monitor.end();
                        ImportKeggModulesAction.this.setStatus("Ok");
                    } else {
                        ImportKeggModulesAction.this.setStatus("Operation cancelled");
                    }
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }

    private void setStatus(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppFrame.instance().setStatusText(msg);
            }
        });
    }
}

