/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.Query;
import org.gitools.ui.biomart.wizard.BiomartTableWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class ImportBiomartTableAction
extends BaseAction {
    private static final long serialVersionUID = 4381993756203388654L;

    public ImportBiomartTableAction() {
        super("Biomart Table ...");
        this.setLargeIconFromResource("/img/Biomart24.png");
        this.setSmallIconFromResource("/img/Biomart16.png");
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        final BiomartTableWizard wizard = new BiomartTableWizard();
        WizardDialog wdlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wdlg.open();
        if (wdlg.isCancelled()) {
            return;
        }
        final File file = wizard.getSelectedFile();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Downloading data...", 1);
                Query query = wizard.getQuery();
                String format = wizard.getFormat().getMime();
                BiomartService service = wizard.getService();
                try {
                    service.queryTable(query, file, format, wizard.isSkipRowsWithEmptyValuesEnabled(), wizard.emptyValuesReplacement(), monitor);
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
                monitor.end();
            }
        });
    }
}

