/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.restful.model.Query;
import org.gitools.ui.biomart.wizard.BiomartModulesWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class ImportBiomartModulesAction
extends BaseAction {
    private static final long serialVersionUID = 668140963768246841L;

    public ImportBiomartModulesAction() {
        super("Biomart Modules (advanced users) ...");
        this.setLargeIconFromResource("/img/Biomart24.png");
        this.setSmallIconFromResource("/img/Biomart16.png");
        this.setDefaultEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        final BiomartModulesWizard wizard = new BiomartModulesWizard();
        WizardDialog wdlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wdlg.open();
        if (wdlg.isCancelled()) {
            return;
        }
        final File file = wizard.getSelectedFile();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Downloading data...", 1);
                Query query = wizard.getQuery();
                String format = wizard.getFormat().getMime();
                BiomartService service = wizard.getService();
                try {
                    service.queryModule(query, file, format, monitor);
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
                monitor.end();
            }
        });
    }
}

