/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.drawer.ColorScaleDrawer;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.gitools.heatmap.Heatmap;
import org.gitools.model.decorator.ElementDecorator;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.scale.ScaleExportWizard;
import org.gitools.ui.settings.Settings;

public class ExportScaleImageAction
extends BaseAction {
    private static final long serialVersionUID = -7288045475037410310L;

    public ExportScaleImageAction() {
        super("Export scale as an image ...");
        this.setDesc("Export the scale as an image file");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap;
    }

    public void actionPerformed(ActionEvent e) {
        IColorScale scale;
        AbstractEditor editor = ActionUtils.getSelectedEditor();
        if (editor == null) {
            return;
        }
        Object model = editor.getModel();
        if (!(model instanceof Heatmap)) {
            return;
        }
        Heatmap hm = (Heatmap)model;
        ElementDecorator cd = hm.getActiveCellDecorator();
        IColorScale iColorScale = scale = cd != null ? cd.getScale() : null;
        if (scale == null) {
            return;
        }
        final ScaleExportWizard wz = new ScaleExportWizard();
        wz.setTitle("Export scale to image ...");
        wz.getSavePage().setFileNameWithoutExtension(PersistenceUtils.getFileName((String)editor.getName()) + "-scale");
        wz.getSavePage().setFolder(Settings.getDefault().getLastExportPath());
        wz.getSavePage().setFormats(new FileFormat[]{FileFormats.PNG, FileFormats.JPG});
        wz.setScale(scale);
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        Settings.getDefault().setLastExportPath(wz.getSavePage().getFolder());
        final File file = wz.getSavePage().getPathAsFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        final String formatExtension = wz.getSavePage().getFormat().getExtension();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Exporting scale to image ...", 1);
                    monitor.info("File: " + file.getName());
                    ColorScaleDrawer drawer = new ColorScaleDrawer(scale);
                    if (wz.isPartialRange()) {
                        drawer.setZoomRangeMin(wz.getRangeMin());
                        drawer.setZoomRangeMax(wz.getRangeMax());
                    }
                    Dimension size = drawer.getSize();
                    size.width = wz.getScaleSize();
                    BufferedImage bi = new BufferedImage(size.width, size.height, 1);
                    Graphics2D g = bi.createGraphics();
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, size.width, size.height);
                    drawer.draw(g, new Rectangle(new Point(), size), new Rectangle(new Point(), size));
                    ImageIO.write((RenderedImage)bi, formatExtension, file);
                    monitor.end();
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText("Image created.");
    }
}

