/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.gitools.exporter.TextMatrixViewExporter;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.utils.FileChooserUtils;

public class ExportMatrixAction
extends BaseAction {
    private static final long serialVersionUID = -7288045475037410310L;

    public ExportMatrixAction() {
        super("Export matrix ...");
        this.setDesc("Export a matrix");
        this.setMnemonic(80);
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        final IMatrixView matrixView = ActionUtils.getHeatmapMatrixView();
        if (matrixView == null) {
            return;
        }
        List properties = matrixView.getCellAdapter().getProperties();
        Object[] propNames = new String[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            propNames[i] = ((IElementAttribute)properties.get(i)).getName();
        }
        int selectedPropIndex = matrixView.getSelectedPropertyIndex();
        selectedPropIndex = selectedPropIndex >= 0 ? selectedPropIndex : 0;
        selectedPropIndex = selectedPropIndex < properties.size() ? selectedPropIndex : 0;
        String selected = (String)JOptionPane.showInputDialog(AppFrame.instance(), "What do you want to export ?", "Export table data", 3, null, propNames, propNames[selectedPropIndex]);
        if (selected == null || selected.isEmpty()) {
            return;
        }
        int index = 0;
        for (int j = 0; j < propNames.length; ++j) {
            if (!((String)propNames[j]).equals(selected)) continue;
            index = j;
        }
        final int propIndex = index;
        final File file = FileChooserUtils.selectFile("Select destination file", Settings.getDefault().getLastExportPath(), 1);
        if (file == null) {
            return;
        }
        Settings.getDefault().setLastExportPath(file.getAbsolutePath());
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Exporting to image ...", 1);
                    monitor.info("File: " + file.getName());
                    TextMatrixViewExporter.exportMatrix((IMatrixView)matrixView, (int)propIndex, (File)file);
                    monitor.end();
                }
                catch (IOException ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText(selected + " exported.");
    }
}

