/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import org.gitools.heatmap.Heatmap;
import org.gitools.label.AnnotationsPatternProvider;
import org.gitools.label.LabelProvider;
import org.gitools.label.MatrixColumnsLabelProvider;
import org.gitools.label.MatrixRowsLabelProvider;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.wizard.common.ExportHeatmapLabelsWizard;

public class ExportHeatmapLabelsAction
extends BaseAction {
    private static final long serialVersionUID = -7288045475037410310L;

    public ExportHeatmapLabelsAction() {
        super("Export labels ...");
        this.setDesc("Export row or column labels");
        this.setMnemonic(78);
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        Object model;
        AbstractEditor editor = AppFrame.instance().getEditorsPanel().getSelectedEditor();
        Object object = model = editor != null ? editor.getModel() : null;
        if (model == null || !(model instanceof Heatmap)) {
            return;
        }
        final Heatmap hm = (Heatmap)model;
        final ExportHeatmapLabelsWizard wiz = new ExportHeatmapLabelsWizard(hm);
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        final IMatrixView matrixView = hm.getMatrixView();
        final File file = wiz.getSavePage().getPathAsFile();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Exporting labels ...", 1);
                    monitor.info("File: " + file.getName());
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    MatrixRowsLabelProvider labelProvider = null;
                    AnnotationMatrix annMatrix = null;
                    switch (wiz.getWhichLabels()) {
                        case VISIBLE_ROWS: {
                            labelProvider = new MatrixRowsLabelProvider((IMatrix)matrixView);
                            annMatrix = hm.getRowDim().getAnnotations();
                            break;
                        }
                        case VISIBLE_COLUMNS: {
                            labelProvider = new MatrixColumnsLabelProvider((IMatrix)matrixView);
                            annMatrix = hm.getColumnDim().getAnnotations();
                            break;
                        }
                        case HIDDEN_ROWS: {
                            labelProvider = ExportHeatmapLabelsAction.this.hiddenRowsLabelProvider(matrixView);
                            annMatrix = hm.getRowDim().getAnnotations();
                            break;
                        }
                        case HIDDEN_COLUMNS: {
                            labelProvider = ExportHeatmapLabelsAction.this.hiddenColumnsLabelProvider(matrixView);
                            annMatrix = hm.getColumnDim().getAnnotations();
                        }
                    }
                    String pattern = wiz.getPattern();
                    if (!pattern.equalsIgnoreCase("${id}")) {
                        labelProvider = new AnnotationsPatternProvider((LabelProvider)labelProvider, annMatrix, pattern);
                    }
                    for (int i = 0; i < labelProvider.getCount(); ++i) {
                        pw.println(labelProvider.getLabel(i));
                    }
                    pw.close();
                    monitor.end();
                }
                catch (IOException ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText("Labels exported.");
    }

    private LabelProvider hiddenRowsLabelProvider(IMatrixView matrixView) {
        int[] visibleIndices = matrixView.getVisibleRows();
        HashSet<Integer> visibleSet = new HashSet<Integer>();
        for (int i = 0; i < visibleIndices.length; ++i) {
            visibleSet.add(visibleIndices[i]);
        }
        IMatrix contents = matrixView.getContents();
        int j = 0;
        int count = contents.getRowCount();
        int[] hiddenIndices = new int[count - visibleIndices.length];
        for (int i = 0; i < count; ++i) {
            if (visibleSet.contains(i)) continue;
            hiddenIndices[j++] = i;
        }
        MatrixView hiddenView = new MatrixView(matrixView);
        hiddenView.setVisibleRows(hiddenIndices);
        return new MatrixRowsLabelProvider((IMatrix)hiddenView);
    }

    private LabelProvider hiddenColumnsLabelProvider(IMatrixView matrixView) {
        int[] visibleIndices = matrixView.getVisibleColumns();
        HashSet<Integer> visibleSet = new HashSet<Integer>();
        for (int i = 0; i < visibleIndices.length; ++i) {
            visibleSet.add(visibleIndices[i]);
        }
        IMatrix contents = matrixView.getContents();
        int j = 0;
        int count = contents.getColumnCount();
        int[] hiddenIndices = new int[count - visibleIndices.length];
        for (int i = 0; i < count; ++i) {
            if (visibleSet.contains(i)) continue;
            hiddenIndices[j++] = i;
        }
        MatrixView hiddenView = new MatrixView(matrixView);
        hiddenView.setVisibleColumns(hiddenIndices);
        return new MatrixColumnsLabelProvider((IMatrix)hiddenView);
    }
}

