/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.file;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.drawer.HeatmapDrawer;
import org.gitools.persistence.FileFormat;
import org.gitools.persistence.FileFormats;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;
import org.gitools.ui.settings.Settings;
import org.gitools.ui.wizard.common.SaveFileWizard;

public class ExportHeatmapImageAction
extends BaseAction {
    private static final long serialVersionUID = -7288045475037410310L;

    public ExportHeatmapImageAction() {
        super("Export heatmap as an image ...");
        this.setDesc("Export the heatmap as an image file");
        this.setMnemonic(73);
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap;
    }

    public void actionPerformed(ActionEvent e) {
        AbstractEditor editor = ActionUtils.getSelectedEditor();
        if (editor == null) {
            return;
        }
        final Object model = editor.getModel();
        if (!(model instanceof Heatmap)) {
            return;
        }
        SaveFileWizard saveWiz = SaveFileWizard.createSimple("Export heatmap to image ...", PersistenceUtils.getFileName((String)editor.getName()), Settings.getDefault().getLastExportPath(), new FileFormat[]{FileFormats.PNG, FileFormats.JPG});
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)saveWiz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        Settings.getDefault().setLastExportPath(saveWiz.getFolder());
        final File file = saveWiz.getPathAsFile();
        final String formatExtension = saveWiz.getFormat().getExtension();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Exporting heatmap to image ...", 1);
                    monitor.info("File: " + file.getName());
                    Heatmap hm = (Heatmap)model;
                    HeatmapDrawer drawer = new HeatmapDrawer(hm);
                    drawer.setPictureMode(true);
                    Dimension heatmapSize = drawer.getSize();
                    int type = 1;
                    BufferedImage bi = new BufferedImage(heatmapSize.width, heatmapSize.height, type);
                    Graphics2D g = bi.createGraphics();
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, heatmapSize.width, heatmapSize.height);
                    drawer.draw(g, new Rectangle(new Point(), heatmapSize), new Rectangle(new Point(), heatmapSize));
                    ImageIO.write((RenderedImage)bi, formatExtension, file);
                    monitor.end();
                }
                catch (Exception ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText("Image created.");
    }
}

