/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.gitools.aggregation.AggregatorFactory;
import org.gitools.aggregation.IAggregator;
import org.gitools.aggregation.MultAggregator;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.matrix.sort.MatrixViewSorter;
import org.gitools.matrix.sort.ValueSortCriteria;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.sort.ValueSortDialog;

public class SortByValueAction
extends BaseAction {
    private static final long serialVersionUID = -1582437709508438222L;

    public SortByValueAction() {
        super("Sort by value ...");
        this.setDesc("Sort by value ...");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        final IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        int aggrIndex = -1;
        IAggregator[] aggregators = AggregatorFactory.getAggregatorsArray();
        for (int i = 0; i < aggregators.length && aggrIndex == -1; ++i) {
            if (!aggregators[i].getClass().equals(MultAggregator.class)) continue;
            aggrIndex = i;
        }
        int attrIndex = -1;
        List cellProps = matrixView.getCellAdapter().getProperties();
        String[] attributeNames = new String[cellProps.size()];
        for (int i = 0; i < cellProps.size(); ++i) {
            String name;
            attributeNames[i] = name = ((IElementAttribute)cellProps.get(i)).getName();
            if (attrIndex != -1 || !name.contains("p-value")) continue;
            attrIndex = i;
        }
        if (attrIndex == -1) {
            attrIndex = 0;
        }
        ArrayList<ValueSortCriteria> initialCriteria = new ArrayList<ValueSortCriteria>(1);
        if (attributeNames.length > 0) {
            initialCriteria.add(new ValueSortCriteria(attributeNames[attrIndex], attrIndex, aggregators[aggrIndex], ValueSortCriteria.SortDirection.ASCENDING));
        }
        final ValueSortDialog dlg = new ValueSortDialog(AppFrame.instance(), attributeNames, aggregators, ValueSortCriteria.SortDirection.values(), initialCriteria);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        final List<ValueSortCriteria> criteriaList = dlg.getCriteriaList();
        if (criteriaList.size() == 0) {
            AppFrame.instance().setStatusText("No criteria specified.");
            return;
        }
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Sorting ...", 1);
                ValueSortCriteria[] criteriaArray = new ValueSortCriteria[criteriaList.size()];
                MatrixViewSorter.sortByValue((IMatrixView)matrixView, (ValueSortCriteria[])criteriaList.toArray(criteriaArray), (boolean)dlg.isApplyToRowsChecked(), (boolean)dlg.isApplyToColumnsChecked());
                monitor.end();
            }
        });
        AppFrame.instance().setStatusText("Sorted.");
    }
}

