/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import org.gitools.aggregation.AggregatorFactory;
import org.gitools.aggregation.IAggregator;
import org.gitools.aggregation.MultAggregator;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.filter.MatrixViewLabelFilter;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.sort.MatrixViewSorter;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizardPage;
import org.gitools.ui.platform.wizard.PageDialog;
import org.gitools.ui.sort.MutualExclusionSortPage;

public class SortByMutualExclusionAction
extends BaseAction {
    private static final long serialVersionUID = -1582437709508438222L;

    public SortByMutualExclusionAction() {
        super("Sort by mutual exclusion ...");
        this.setDesc("Sort by mutual exclusion ...");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        Object model;
        AbstractEditor editor = AppFrame.instance().getEditorsPanel().getSelectedEditor();
        Object object = model = editor != null ? editor.getModel() : null;
        if (model == null || !(model instanceof Heatmap)) {
            return;
        }
        final Heatmap hm = (Heatmap)model;
        final MutualExclusionSortPage page = new MutualExclusionSortPage(hm);
        PageDialog dlg = new PageDialog((Window)AppFrame.instance(), (IWizardPage)page);
        if (hm.getMatrixView().getSelectedColumns().length > 0) {
            page.setFilterDimension(MatrixViewLabelFilter.FilterDimension.COLUMNS);
        }
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        int aggrIndex = -1;
        IAggregator[] aggregators = AggregatorFactory.getAggregatorsArray();
        for (int i = 0; i < aggregators.length && aggrIndex == -1; ++i) {
            if (!aggregators[i].getClass().equals(MultAggregator.class)) continue;
            aggrIndex = i;
        }
        final IMatrixView matrixView = hm.getMatrixView();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                monitor.begin("Sorting ...", 1);
                AnnotationMatrix am = null;
                MatrixViewLabelFilter.FilterDimension dim = page.getFilterDimension();
                switch (dim) {
                    case ROWS: {
                        am = hm.getRowDim().getAnnotations();
                        break;
                    }
                    case COLUMNS: {
                        am = hm.getColumnDim().getAnnotations();
                    }
                }
                MatrixViewSorter.sortByMutualExclusion((IMatrixView)matrixView, (String)page.getPattern(), (AnnotationMatrix)am, page.getValues(), (boolean)page.isUseRegexChecked(), (boolean)dim.equals((Object)MatrixViewLabelFilter.FilterDimension.ROWS), (boolean)dim.equals((Object)MatrixViewLabelFilter.FilterDimension.COLUMNS));
                monitor.end();
            }
        });
        AppFrame.instance().setStatusText("Sorted.");
    }
}

