/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import java.awt.event.ActionEvent;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;

public class ShowAllAction
extends BaseAction {
    private static final long serialVersionUID = 7110623490709997414L;
    private ElementType type;

    public ShowAllAction(ElementType type) {
        super(null);
        this.type = type;
        switch (type) {
            case ROWS: {
                this.setName("Show all rows");
                this.setDesc("Show all rows");
                this.setSmallIconFromResource("/img/RowShowAll16.gif");
                this.setLargeIconFromResource("/img/RowShowAll24.gif");
                break;
            }
            case COLUMNS: {
                this.setName("Show all columns");
                this.setDesc("Show all columns");
                this.setSmallIconFromResource("/img/ColumnShowAll16.gif");
                this.setLargeIconFromResource("/img/ColumnShowAll24.gif");
            }
        }
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        IMatrix contents = matrixView.getContents();
        if (this.type == ElementType.ROWS) {
            int rowCount = contents.getRowCount();
            int[] visibleRows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                visibleRows[i] = i;
            }
            matrixView.setVisibleRows(visibleRows);
            AppFrame.instance().setStatusText(visibleRows.length + " rows");
        } else if (this.type == ElementType.COLUMNS) {
            int columnCount = contents.getColumnCount();
            int[] visibleColumns = new int[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                visibleColumns[i] = i;
            }
            matrixView.setVisibleColumns(visibleColumns);
            AppFrame.instance().setStatusText(visibleColumns.length + " columns");
        }
    }

    public static enum ElementType {
        ROWS,
        COLUMNS;

    }
}

