/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import java.awt.event.ActionEvent;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.actions.BaseAction;

public class MoveSelectionAction
extends BaseAction {
    private static final long serialVersionUID = 2499014276737037571L;
    protected MoveDirection dir;

    public MoveSelectionAction(MoveDirection dir) {
        super(null);
        this.dir = dir;
        switch (dir) {
            case ROW_UP: {
                this.setName("Move row up");
                this.setDesc("Move row up");
                this.setSmallIconFromResource("/img/MoveRowsUp16.gif");
                this.setLargeIconFromResource("/img/MoveRowsUp24.gif");
                this.setMnemonic(85);
                break;
            }
            case ROW_DOWN: {
                this.setName("Move row down");
                this.setDesc("Move row down");
                this.setSmallIconFromResource("/img/MoveRowsDown16.gif");
                this.setLargeIconFromResource("/img/MoveRowsDown24.gif");
                this.setMnemonic(68);
                break;
            }
            case COL_LEFT: {
                this.setName("Move column left");
                this.setDesc("Move column left");
                this.setSmallIconFromResource("/img/MoveColsLeft16.gif");
                this.setLargeIconFromResource("/img/MoveColsLeft24.gif");
                this.setMnemonic(76);
                break;
            }
            case COL_RIGHT: {
                this.setName("Move column right");
                this.setDesc("Move column right");
                this.setSmallIconFromResource("/img/MoveColsRight16.gif");
                this.setLargeIconFromResource("/img/MoveColsRight24.gif");
                this.setMnemonic(82);
            }
        }
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        switch (this.dir) {
            case ROW_UP: {
                matrixView.moveRowsUp(matrixView.getSelectedRows());
                break;
            }
            case ROW_DOWN: {
                matrixView.moveRowsDown(matrixView.getSelectedRows());
                break;
            }
            case COL_LEFT: {
                matrixView.moveColumnsLeft(matrixView.getSelectedColumns());
                break;
            }
            case COL_RIGHT: {
                matrixView.moveColumnsRight(matrixView.getSelectedColumns());
            }
        }
    }

    public static enum MoveDirection {
        ROW_UP,
        ROW_DOWN,
        COL_LEFT,
        COL_RIGHT;

    }
}

