/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import java.awt.event.ActionEvent;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;

public class HideSelectionAction
extends BaseAction {
    private static final long serialVersionUID = 1453040322414160605L;
    private ElementType type;

    public HideSelectionAction(ElementType type) {
        super(null);
        this.type = type;
        switch (type) {
            case ROWS: {
                this.setName("Hide selected rows");
                this.setDesc("Hide selected rows");
                this.setSmallIconFromResource("/img/RowHide16.gif");
                this.setLargeIconFromResource("/img/RowHide24.gif");
                this.setMnemonic(87);
                break;
            }
            case COLUMNS: {
                this.setName("Hide selected columns");
                this.setDesc("Hide selected columns");
                this.setSmallIconFromResource("/img/ColumnHide16.gif");
                this.setLargeIconFromResource("/img/ColumnHide24.gif");
                this.setMnemonic(79);
            }
        }
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        String msg = "";
        switch (this.type) {
            case ROWS: {
                msg = "Selected rows hidden.";
                matrixView.hideRows(matrixView.getSelectedRows());
                break;
            }
            case COLUMNS: {
                msg = "Selected columns hidden.";
                matrixView.hideColumns(matrixView.getSelectedColumns());
            }
        }
        AppFrame.instance().setStatusText(msg);
    }

    public static enum ElementType {
        ROWS,
        COLUMNS;

    }
}

