/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import org.gitools.aggregation.IAggregator;
import org.gitools.aggregation.MultAggregator;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.sort.MatrixViewSorter;
import org.gitools.matrix.sort.ValueSortCriteria;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class FastSortRowsAction
extends BaseAction {
    private static final long serialVersionUID = -582380114189586206L;

    public FastSortRowsAction() {
        super("Sort rows");
        this.setDesc("Sort rows");
        this.setSmallIconFromResource("/img/SortSelectedColumns16.gif");
        this.setLargeIconFromResource("/img/SortSelectedColumns24.gif");
        this.setMnemonic(83);
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        final IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        final int propIndex = matrixView.getSelectedPropertyIndex();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                ValueSortCriteria[] criteriaArray = new ValueSortCriteria[]{new ValueSortCriteria(propIndex, (IAggregator)new MultAggregator(), ValueSortCriteria.SortDirection.ASCENDING)};
                monitor.begin("Sorting ...", 1);
                MatrixViewSorter.sortByValue((IMatrixView)matrixView, (ValueSortCriteria[])criteriaArray, (boolean)true, (boolean)false);
                monitor.end();
            }
        });
        AppFrame.instance().setStatusText("Rows sorted.");
    }
}

