/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.data;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import org.gitools.clustering.ClusteringMethod;
import org.gitools.clustering.ClusteringResults;
import org.gitools.clustering.HierarchicalClusteringResults;
import org.gitools.clustering.method.value.AbstractClusteringValueMethod;
import org.gitools.clustering.method.value.ClusterUtils;
import org.gitools.heatmap.Heatmap;
import org.gitools.heatmap.HeatmapDim;
import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.heatmap.header.HeatmapHeader;
import org.gitools.heatmap.header.HeatmapHierarchicalColoredLabelsHeader;
import org.gitools.matrix.TransposedMatrixView;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.clustering.values.ClusteringValueWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class ClusteringByValueAction
extends BaseAction {
    public ClusteringByValueAction() {
        super("Clustering");
        this.setDesc("Cluster by values");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        Heatmap heatmap = ActionUtils.getHeatmap();
        if (heatmap == null) {
            return;
        }
        ClusteringValueWizard wiz = new ClusteringValueWizard(heatmap);
        WizardDialog wdlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
        wdlg.setVisible(true);
        if (wdlg.isCancelled()) {
            return;
        }
        AbstractClusteringValueMethod method = wiz.getMethod();
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable((ClusteringMethod)method, wiz, heatmap){
            final /* synthetic */ ClusteringMethod val$method;
            final /* synthetic */ ClusteringValueWizard val$wiz;
            final /* synthetic */ Heatmap val$heatmap;
            {
                this.val$method = clusteringMethod;
                this.val$wiz = clusteringValueWizard;
                this.val$heatmap = heatmap;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.begin("Clustering  ...", 1);
                    ClusteringResults results = this.val$method.cluster(this.val$wiz.getClusterData(), monitor);
                    if (this.val$wiz.isSortDataSelected()) {
                        if (this.val$wiz.isApplyToRows()) {
                            TransposedMatrixView transposedMatrix = new TransposedMatrixView(this.val$heatmap.getMatrixView());
                            ClusterUtils.updateVisibility((IMatrixView)transposedMatrix, (Map)results.getDataIndicesByClusterTitle());
                        } else {
                            ClusterUtils.updateVisibility((IMatrixView)this.val$heatmap.getMatrixView(), (Map)results.getDataIndicesByClusterTitle());
                        }
                    }
                    if (this.val$wiz.isNewickExportSelected()) {
                        File path = this.val$wiz.getSaveFilePage().getPathAsFile();
                        BufferedWriter out = new BufferedWriter(new FileWriter(path));
                        out.write(((HierarchicalClusteringResults)results).getTree().toString());
                        out.flush();
                        out.close();
                    }
                    if (this.val$wiz.isHeaderSelected()) {
                        boolean hcl = results instanceof HierarchicalClusteringResults;
                        HeatmapDim hdim = this.val$wiz.isApplyToRows() ? this.val$heatmap.getRowDim() : this.val$heatmap.getColumnDim();
                        HeatmapHierarchicalColoredLabelsHeader header = hcl ? new HeatmapHierarchicalColoredLabelsHeader(hdim) : new HeatmapColoredLabelsHeader(hdim);
                        header.setTitle("Clustering: " + this.val$wiz.getMethodName());
                        if (hcl) {
                            HeatmapHierarchicalColoredLabelsHeader hclHeader = header;
                            HierarchicalClusteringResults hclResults = (HierarchicalClusteringResults)results;
                            hclHeader.setClusteringResults(hclResults);
                            int level = hclResults.getTree().getDepth() / 2;
                            hclHeader.setTreeLevel(level);
                        }
                        header.updateFromClusterResults(results);
                        if (this.val$wiz.isApplyToRows()) {
                            this.val$heatmap.getRowDim().addHeader((HeatmapHeader)header);
                        } else {
                            this.val$heatmap.getColumnDim().addHeader((HeatmapHeader)header);
                        }
                    }
                    monitor.end();
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
        AppFrame.instance().setStatusText("Clusters created");
    }
}

