/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.analysis;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.analysis.overlapping.OverlappingProcessor;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.MatrixView;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.analysis.overlapping.OverlappingAnalysisEditor;
import org.gitools.ui.analysis.overlapping.wizard.OverlappingAnalysisWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.editor.IEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class OverlappingsAction
extends BaseAction {
    public OverlappingsAction() {
        super("Overlapping");
        this.setDesc("Overlapping analysis");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        AbstractEditor currentEditor = editorPanel.getSelectedEditor();
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        OverlappingAnalysisWizard wiz = new OverlappingAnalysisWizard();
        wiz.setExamplePageEnabled(false);
        wiz.setDataFromMemory(true);
        wiz.setAttributes(matrixView.getCellAttributes());
        wiz.setSaveFilePageEnabled(false);
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
        dlg.open();
        if (dlg.isCancelled()) {
            return;
        }
        final OverlappingAnalysis analysis = wiz.getAnalysis();
        if (!analysis.isTransposeData()) {
            if (matrixView.getSelectedColumns().length > 0) {
                MatrixView mv = new MatrixView(matrixView);
                mv.visibleColumnsFromSelection();
                matrixView = mv;
            }
        } else if (matrixView.getSelectedRows().length > 0) {
            MatrixView mv = new MatrixView(matrixView);
            mv.visibleRowsFromSelection();
            matrixView = mv;
        }
        analysis.setData((IMatrix)matrixView);
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable((IEditor)currentEditor, editorPanel){
            final /* synthetic */ IEditor val$currentEditor;
            final /* synthetic */ EditorsPanel val$editorPanel;
            {
                this.val$currentEditor = iEditor;
                this.val$editorPanel = editorsPanel;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    new OverlappingProcessor(analysis).run(monitor);
                    if (monitor.isCancelled()) {
                        return;
                    }
                    final OverlappingAnalysisEditor editor = new OverlappingAnalysisEditor(analysis);
                    String ext = PersistenceUtils.getExtension((String)this.val$currentEditor.getName());
                    editor.setName(this.val$editorPanel.deriveName(this.val$currentEditor.getName(), ext, "-overlapping", "heatmap"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                            AppFrame.instance().refresh();
                        }
                    });
                    monitor.end();
                    AppFrame.instance().setStatusText("Done.");
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

