/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.analysis;

import cern.colt.function.DoubleProcedure;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.stats.mtc.MTC;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;

public class MtcAction
extends BaseAction {
    private static final long serialVersionUID = 991170566166881702L;
    protected MTC mtc;

    public MtcAction(MTC mtc) {
        super(mtc.getName());
        this.setDesc("Calculate " + mtc.getName() + " multiple test correction");
        this.mtc = mtc;
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        int propIndex;
        final IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        IElementAdapter cellAdapter = matrixView.getCellAdapter();
        final int corrPropIndex = MatrixUtils.correctedValueIndex((IElementAdapter)cellAdapter, (IElementAttribute)cellAdapter.getProperty(propIndex = matrixView.getSelectedPropertyIndex()));
        if (corrPropIndex < 0) {
            JOptionPane.showMessageDialog(AppFrame.instance(), "The property selected doesn't allow multiple test correction.", "Error", 0);
            return;
        }
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable(){

            public void run(IProgressMonitor monitor) {
                int col;
                IMatrix contents = matrixView.getContents();
                int rowCount = contents.getRowCount();
                int columnCount = contents.getColumnCount();
                monitor.begin("Multiple test correction for  " + MtcAction.this.mtc.getName() + " ...", columnCount * 3);
                DoubleMatrix2D values = DoubleFactory2D.dense.make(rowCount, columnCount);
                for (col = 0; col < columnCount; ++col) {
                    for (int row = 0; row < rowCount; ++row) {
                        values.setQuick(row, col, MatrixUtils.doubleValue((Object)contents.getCellValue(row, col, propIndex)));
                    }
                    monitor.worked(1);
                }
                for (col = 0; col < columnCount; ++col) {
                    DoubleMatrix1D columnValues = values.viewColumn(col).viewSelection(new DoubleProcedure(){

                        public boolean apply(double v) {
                            return !Double.isNaN(v);
                        }
                    });
                    MtcAction.this.mtc.correct(columnValues);
                    monitor.worked(1);
                }
                for (col = 0; col < columnCount; ++col) {
                    for (int row = 0; row < rowCount; ++row) {
                        contents.setCellValue(row, col, corrPropIndex, (Object)values.getQuick(row, col));
                    }
                    monitor.worked(1);
                }
                monitor.end();
            }
        });
        AppFrame.instance().setStatusText(this.mtc.getName() + " done.");
    }
}

