/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.analysis;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.gitools.analysis.groupcomparison.GroupComparisonAnalysis;
import org.gitools.analysis.groupcomparison.GroupComparisonProcessor;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.analysis.groupcomparison.editor.GroupComparisonAnalysisEditor;
import org.gitools.ui.analysis.groupcomparison.wizard.GroupComparisonAnalysisFromEditorWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.editor.IEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class GroupComparisonAction
extends BaseAction {
    public GroupComparisonAction() {
        super("Group Comparison");
        this.setDesc("Group Comparison analysis");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        AbstractEditor currentEditor = editorPanel.getSelectedEditor();
        Heatmap heatmap = ActionUtils.getHeatmap();
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (heatmap == null) {
            return;
        }
        List attributes = matrixView.getCellAttributes();
        String[] attributeNames = new String[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            attributeNames[i] = ((IElementAttribute)attributes.get(i)).getName();
        }
        GroupComparisonAnalysisFromEditorWizard wiz = new GroupComparisonAnalysisFromEditorWizard(heatmap);
        WizardDialog dlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wiz);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        final GroupComparisonAnalysis analysis = wiz.getAnalysis();
        analysis.setData((IMatrix)matrixView);
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable((IEditor)currentEditor, editorPanel){
            final /* synthetic */ IEditor val$currentEditor;
            final /* synthetic */ EditorsPanel val$editorPanel;
            {
                this.val$currentEditor = iEditor;
                this.val$editorPanel = editorsPanel;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    new GroupComparisonProcessor(analysis).run(monitor);
                    if (monitor.isCancelled()) {
                        return;
                    }
                    final GroupComparisonAnalysisEditor editor = new GroupComparisonAnalysisEditor(analysis);
                    String ext = PersistenceUtils.getExtension((String)this.val$currentEditor.getName());
                    if (analysis.getTitle().equals("")) {
                        editor.setName(this.val$editorPanel.deriveName(this.val$currentEditor.getName(), ext, "-comparison", "comparison"));
                    } else {
                        editor.setName(this.val$editorPanel.createName(analysis.getTitle(), ".comparison"));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                            AppFrame.instance().refresh();
                        }
                    });
                    monitor.end();
                    AppFrame.instance().setStatusText("Done.");
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

