/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui.actions.analysis;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import org.gitools.analysis.combination.CombinationAnalysis;
import org.gitools.analysis.combination.CombinationCommand;
import org.gitools.heatmap.Heatmap;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.IMatrixView;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.ui.actions.ActionUtils;
import org.gitools.ui.analysis.combination.editor.CombinationAnalysisEditor;
import org.gitools.ui.analysis.combination.wizard.CombinationAnalysisWizard;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.actions.BaseAction;
import org.gitools.ui.platform.editor.AbstractEditor;
import org.gitools.ui.platform.editor.EditorsPanel;
import org.gitools.ui.platform.editor.IEditor;
import org.gitools.ui.platform.progress.JobRunnable;
import org.gitools.ui.platform.progress.JobThread;
import org.gitools.ui.platform.wizard.IWizard;
import org.gitools.ui.platform.wizard.WizardDialog;

public class CombinationsAction
extends BaseAction {
    public CombinationsAction() {
        super("Combinations");
        this.setDesc("Combinations");
    }

    public boolean isEnabledByModel(Object model) {
        return model instanceof Heatmap || model instanceof IMatrixView;
    }

    public void actionPerformed(ActionEvent e) {
        EditorsPanel editorPanel = AppFrame.instance().getEditorsPanel();
        AbstractEditor currentEditor = editorPanel.getSelectedEditor();
        IMatrixView matrixView = ActionUtils.getMatrixView();
        if (matrixView == null) {
            return;
        }
        CombinationAnalysisWizard wizard = new CombinationAnalysisWizard();
        wizard.setExamplePageEnabled(false);
        wizard.setDataFromMemory(true);
        wizard.setAttributes(matrixView.getCellAttributes());
        wizard.setSaveFilePageEnabled(false);
        WizardDialog wizDlg = new WizardDialog((Window)AppFrame.instance(), (IWizard)wizard);
        wizDlg.open();
        if (wizDlg.isCancelled()) {
            return;
        }
        final CombinationAnalysis analysis = wizard.getAnalysis();
        analysis.setData((IMatrix)matrixView);
        File columnSetsFile = wizard.getColumnSetsPage().getFile();
        String columnSetsPath = columnSetsFile != null ? columnSetsFile.getAbsolutePath() : null;
        String columnSetsMime = columnSetsFile != null ? wizard.getColumnSetsPage().getFileFormat().getMime() : null;
        final CombinationCommand cmd = new CombinationCommand(analysis, null, null, columnSetsMime, columnSetsPath, null, null);
        cmd.setStoreAnalysis(false);
        JobThread.execute((Window)AppFrame.instance(), (JobRunnable)new JobRunnable((IEditor)currentEditor, editorPanel){
            final /* synthetic */ IEditor val$currentEditor;
            final /* synthetic */ EditorsPanel val$editorPanel;
            {
                this.val$currentEditor = iEditor;
                this.val$editorPanel = editorsPanel;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    cmd.run(monitor);
                    if (monitor.isCancelled()) {
                        return;
                    }
                    final CombinationAnalysisEditor editor = new CombinationAnalysisEditor(analysis);
                    String ext = PersistenceUtils.getExtension((String)this.val$currentEditor.getName());
                    editor.setName(this.val$editorPanel.deriveName(this.val$currentEditor.getName(), ext, "-combination", "heatmap"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppFrame.instance().getEditorsPanel().addEditor((AbstractEditor)editor);
                            AppFrame.instance().refresh();
                        }
                    });
                    monitor.end();
                    AppFrame.instance().setStatusText("Done.");
                }
                catch (Throwable ex) {
                    monitor.exception(ex);
                }
            }
        });
    }
}

