/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.ui;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.gitools.persistence.PersistenceInitialization;
import org.gitools.ui.actions.Actions;
import org.gitools.ui.batch.CommandExecutor;
import org.gitools.ui.batch.CommandListener;
import org.gitools.ui.platform.AppFrame;
import org.gitools.ui.platform.help.Help;
import org.gitools.ui.settings.Settings;

public class Main {
    public static void main(String[] args) {
        CommandExecutor cmdExecutor = new CommandExecutor();
        if (args.length > 0 && !cmdExecutor.checkArguments(args, new PrintWriter(System.err))) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Error loading Look&Feel:");
            e.printStackTrace();
        }
        Logger.getLogger("org.lobobrowser").setLevel(Level.WARNING);
        try {
            Help.getDefault().loadProperties(Main.class.getResourceAsStream("/help/help.properties"));
            Help.getDefault().loadUrlMap(Main.class.getResourceAsStream("/help/help.mappings"));
        }
        catch (Exception ex) {
            System.err.println("Error loading help system:");
            ex.printStackTrace();
        }
        PersistenceInitialization.registerFormats();
        Actions.init();
        AppFrame.instance().start();
        boolean portEnabled = Settings.getDefault().isPortEnabled();
        String portString = null;
        if (portEnabled || portString != null) {
            int port = Settings.getDefault().getDefaultPort();
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            CommandListener.start(port);
        }
        if (args.length > 0) {
            cmdExecutor.execute(args, new PrintWriter(System.err));
        }
    }
}

