/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.tools.impl;

import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.ToolLifeCycle;
import edu.upf.bg.tools.args.BaseArguments;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolUsageException;
import edu.upf.bg.tools.exception.ToolValidationException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.CmdLineParser;

public abstract class AbstractTool<Context>
implements ToolLifeCycle<Context> {
    private Context context;

    public Context getContext() {
        return this.context;
    }

    @Override
    public void initialize(Context context) throws ToolException {
        this.context = context;
    }

    @Override
    public void validate(Object argsObject) throws ToolException {
        if (!(argsObject instanceof BaseArguments)) {
            return;
        }
        BaseArguments args = (BaseArguments)argsObject;
        if (args.loglevel != null) {
            Pattern pat = Pattern.compile("^(.*)=(.*)$");
            for (String loglevel : args.loglevel) {
                Matcher mat = pat.matcher(loglevel);
                if (!mat.matches() || mat.groupCount() != 2) {
                    throw new ToolValidationException("Invalid -loglevel argument: " + loglevel);
                }
                String pkg = mat.group(1);
                String levelName = mat.group(2);
                if (pkg == null || levelName == null) {
                    throw new ToolValidationException("Invalid -loglevel package: " + loglevel);
                }
                Level level = Level.toLevel((String)levelName);
                if (level == null) {
                    throw new ToolValidationException("Invalid -loglevel level name: " + loglevel);
                }
                Logger.getLogger((String)pkg).setLevel(level);
            }
        }
        if (args.help) {
            throw new ToolUsageException();
        }
    }

    @Override
    public void run(Object argsObject) throws ToolException {
    }

    @Override
    public void uninitialize() throws ToolException {
    }

    @Override
    public void printUsage(PrintStream outputStream, String appName, ToolDescriptor toolDesc, CmdLineParser parser) {
        outputStream.print(toolDesc.getName() + " usage:\n\t" + appName + " " + toolDesc.getName());
        parser.printSingleLineUsage((OutputStream)outputStream);
        outputStream.println("\n");
        parser.printUsage((OutputStream)outputStream);
        outputStream.println();
    }
}

