/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.tools;

import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.ToolSet;
import edu.upf.bg.tools.exception.ToolException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlToolSetResource {
    protected File file;

    public XmlToolSetResource(File file) {
        this.file = file;
    }

    public ToolSet load() throws ToolException {
        try {
            return XmlToolSetResource.load(new FileReader(this.file));
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
    }

    public void save(ToolSet toolSet) throws ToolException {
        try {
            XmlToolSetResource.save(toolSet, new FileWriter(this.file));
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
    }

    public static ToolSet load(Reader reader) throws ToolException {
        ToolSet toolSet = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ToolSet.class, ToolDescriptor.class, ArrayList.class});
            Unmarshaller u = context.createUnmarshaller();
            toolSet = (ToolSet)u.unmarshal(reader);
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        return toolSet;
    }

    public static void save(ToolSet toolSet, Writer writer) throws ToolException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ToolSet.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)toolSet, writer);
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
    }
}

