/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.tools;

import edu.upf.bg.tools.ToolDescriptor;
import edu.upf.bg.tools.ToolLifeCycle;
import edu.upf.bg.tools.ToolSet;
import edu.upf.bg.tools.args.BaseArguments;
import edu.upf.bg.tools.exception.ToolException;
import edu.upf.bg.tools.exception.ToolValidationException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class ToolManager {
    protected ToolSet toolSet;
    protected String appName;
    protected String appVersion;
    private int usageWidth;
    protected PrintStream outputStream = System.out;
    protected PrintStream errorStream = System.err;

    public ToolManager(ToolSet toolSet, String appName, String appVersion) {
        this.toolSet = toolSet;
        this.appName = appName;
        this.appVersion = appVersion;
        this.usageWidth = 120;
    }

    public ToolSet getToolSet() {
        return this.toolSet;
    }

    public void setToolSet(ToolSet toolSet) {
        this.toolSet = toolSet;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public int getUsageWidth() {
        return this.usageWidth;
    }

    public void setUsageWidth(int usageWidth) {
        this.usageWidth = usageWidth;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    public int launch(String[] args) throws ToolException {
        return this.launch(args, null);
    }

    public int launch(String[] args, Object context) throws ToolException {
        if (args.length < 1) {
            this.printUsage(this.errorStream);
            return -1;
        }
        String toolName = args[0];
        if (toolName.equalsIgnoreCase("list")) {
            this.printAvailableTools(this.outputStream, this.toolSet);
            return 0;
        }
        if (toolName.equalsIgnoreCase("help")) {
            if (args.length < 2) {
                this.printUsage(this.outputStream);
                return 0;
            }
            this.printToolUsage(args[1], this.appName, context);
            return 0;
        }
        String[] toolArgs = new String[args.length - 1];
        System.arraycopy(args, 1, toolArgs, 0, toolArgs.length);
        return this.launch(toolName, toolArgs, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launch(String name, String[] args, Object context) throws ToolException {
        Object argsObject;
        ToolLifeCycle tool;
        ToolDescriptor toolDesc = this.getToolDescriptorFromName(name);
        if (toolDesc == null) {
            throw new ToolException("There isn't any tool named '" + name + "'");
        }
        try {
            Class<? extends ToolLifeCycle> lifeCycleClass = toolDesc.getLifeCycleClass();
            if (lifeCycleClass == null) {
                throw new ToolException("LifeCycle class not defined.");
            }
            tool = lifeCycleClass.newInstance();
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        tool.initialize(context);
        Class<?> argsClass = toolDesc.getArgumentsClass();
        if (argsClass == null) {
            throw new ToolException("Tool '" + name + "' doesn't define an arguments class");
        }
        try {
            argsObject = argsClass.newInstance();
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        CmdLineParser parser = new CmdLineParser(argsObject);
        parser.setUsageWidth(this.usageWidth);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.logExceptionError(toolDesc, args, e, this.errorStream, null);
            System.exit(-1);
        }
        String logName = null;
        if (argsObject instanceof BaseArguments) {
            BaseArguments bargs = (BaseArguments)argsObject;
            if (bargs.help) {
                tool.printUsage(this.outputStream, this.appName, toolDesc, parser);
                System.exit(0);
            }
            if (bargs.errorLog != null) {
                logName = bargs.errorLog;
            }
        }
        try {
            tool.validate(argsObject);
        }
        catch (ToolValidationException e) {
            this.errorStream.println(e.getLocalizedMessage());
            return -1;
        }
        int code = 0;
        try {
            tool.run(argsObject);
        }
        catch (ToolException e) {
            code = -1;
            this.logExceptionError(toolDesc, args, e, this.errorStream, logName);
        }
        finally {
            try {
                tool.uninitialize();
            }
            catch (Exception e) {}
        }
        return code;
    }

    private void logExceptionError(ToolDescriptor toolDesc, String[] args, Throwable e, PrintStream err, String logName) {
        err.println("ERROR " + this.getErrorLine(e));
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            err.println("  Caused by " + this.getErrorLine(cause));
        }
        try {
            File file = null;
            Writer writer = null;
            if (logName == null) {
                file = File.createTempFile("intogen-error-report-" + toolDesc.getName() + "-", ".txt");
                writer = new BufferedWriter(new FileWriter(file));
            } else if (logName.equals("-")) {
                writer = new OutputStreamWriter(this.errorStream);
            } else {
                file = new File(logName);
                writer = new FileWriter(file);
            }
            PrintWriter pw = new PrintWriter(writer);
            pw.println("Error executing tool '" + toolDesc.getName() + "':");
            pw.print("\n  Arguments:");
            for (String arg : args) {
                if (arg.indexOf(32) != -1) {
                    pw.print(" \"" + arg + "\"");
                    continue;
                }
                pw.print(" " + arg);
            }
            pw.println();
            pw.println("  User: " + System.getProperty("user.name", "unknown"));
            pw.println("  User dir: " + System.getProperty("user.dir", "unknown"));
            pw.println("  Java version: " + System.getProperty("java.version", "unknown"));
            pw.println("  Java HOME: " + System.getProperty("java.home", "unknown"));
            pw.println("  Java CLASSPATH: " + System.getProperty("java.class.path", "unknown"));
            pw.println("  Date/Time: " + new Date());
            pw.println();
            e.printStackTrace(pw);
            pw.close();
            if (file != null) {
                err.println("\nAn error report has been generated on:");
                err.println("\t" + file.getAbsolutePath());
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
    }

    private String getErrorLine(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName());
        String msg = t.getMessage();
        if (msg != null) {
            sb.append(": " + msg);
        }
        return sb.toString();
    }

    public void printToolUsage(String name, String appName, Object context) throws ToolException {
        Object argsObject;
        ToolLifeCycle tool;
        ToolDescriptor toolDesc = this.getToolDescriptorFromName(name);
        if (toolDesc == null) {
            throw new ToolException("There isn't any tool named '" + name + "'");
        }
        try {
            tool = toolDesc.getLifeCycleClass().newInstance();
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        tool.initialize(context);
        Class<?> argsClass = toolDesc.getArgumentsClass();
        if (argsClass == null) {
            throw new ToolException("Tool '" + name + "' doesn't define an arguments class");
        }
        try {
            argsObject = argsClass.newInstance();
        }
        catch (Exception e) {
            throw new ToolException(e);
        }
        CmdLineParser parser = new CmdLineParser(argsObject);
        parser.setUsageWidth(this.usageWidth);
        tool.printUsage(this.outputStream, appName, toolDesc, parser);
    }

    private void printUsage(PrintStream out) {
        out.println(this.appName + " version " + this.appVersion);
        out.println("\nUsage: " + this.appName + " <tool-name> <tool-arguments>\n");
        out.println("To get the list of availables tools write:");
        out.println("\n" + this.appName + " list");
        out.println("\nTo get help for a tool write:");
        out.println("\n" + this.appName + " help <tool-name>");
        out.println();
    }

    private void printAvailableTools(PrintStream out, ToolSet toolSet) {
        out.println("The list of available tools:\n");
        for (ToolDescriptor toolDesc : toolSet.getToolDescriptors()) {
            String name = toolDesc.getName();
            out.print(name);
            for (int i = 0; i < 30 - name.length(); ++i) {
                out.print('.');
            }
            out.println(toolDesc.getDescription());
        }
    }

    private ToolDescriptor getToolDescriptorFromName(String name) {
        for (ToolDescriptor desc : this.toolSet.getToolDescriptors()) {
            if (!desc.getName().equalsIgnoreCase(name)) continue;
            return desc;
        }
        return null;
    }
}

