/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.textpatt;

import java.util.ArrayList;
import java.util.List;

public class TextPattern {
    private String text;
    private List<Token> tokens;

    private static List<Token> internalCompile(String pattern) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (pattern == null) {
            return tokens;
        }
        StringBuilder buff = new StringBuilder();
        StringBuilder varBuff = new StringBuilder();
        int state = 67;
        int pos = 0;
        while (pos < pattern.length()) {
            char ch = pattern.charAt(pos++);
            switch (state) {
                case 67: {
                    if (ch == '$') {
                        state = 36;
                        break;
                    }
                    buff.append(ch);
                    break;
                }
                case 36: {
                    if (ch == '{') {
                        state = 86;
                        tokens.add(new TextToken(buff.toString()));
                        buff.setLength(0);
                        break;
                    }
                    buff.append('$').append(ch);
                    state = 67;
                    break;
                }
                case 86: {
                    if (ch == '}') {
                        state = 88;
                        break;
                    }
                    varBuff.append(ch);
                    break;
                }
                case 88: {
                    tokens.add(new VariableToken(varBuff.toString()));
                    varBuff.setLength(0);
                    --pos;
                    state = 67;
                }
            }
        }
        switch (state) {
            case 36: {
                buff.append('$');
                break;
            }
            case 86: {
                buff.append("${").append((CharSequence)varBuff);
                break;
            }
            case 88: {
                tokens.add(new VariableToken(varBuff.toString()));
                varBuff.setLength(0);
            }
        }
        if (buff.length() > 0) {
            tokens.add(new TextToken(buff.toString()));
        }
        return tokens;
    }

    public static TextPattern compile(String pattern) {
        return new TextPattern(pattern);
    }

    public TextPattern(String pattern) {
        this.tokens = TextPattern.internalCompile(pattern);
    }

    public String getText() {
        return this.text;
    }

    public String generate(VariableValueResolver resolver) {
        StringBuilder sb = new StringBuilder();
        for (Token token : this.tokens) {
            token.generate(resolver, sb);
        }
        return sb.toString();
    }

    private static class VariableToken
    implements Token {
        private String variableName;

        public VariableToken(String variableName) {
            this.variableName = variableName;
        }

        @Override
        public void generate(VariableValueResolver resolver, StringBuilder sb) {
            sb.append(resolver.resolveValue(this.variableName));
        }
    }

    private static class TextToken
    implements Token {
        private String text;

        public TextToken(String text) {
            this.text = text;
        }

        @Override
        public void generate(VariableValueResolver resolver, StringBuilder sb) {
            sb.append(this.text);
        }
    }

    private static interface Token {
        public void generate(VariableValueResolver var1, StringBuilder var2);
    }

    public static interface VariableValueResolver {
        public String resolveValue(String var1);
    }
}

