/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.textpatt;

import edu.upf.bg.textpatt.TextPattern;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanResolver
implements TextPattern.VariableValueResolver {
    private Class<?> beanClass;
    private Object beanInstance;
    private Map<String, BeanProperty> beanProperties;

    public BeanResolver(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanProperties = this.readProperties(beanClass);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Object getBeanInstance() {
        return this.beanInstance;
    }

    public void setBeanInstance(Object beanInstance) {
        this.beanInstance = beanInstance;
    }

    @Override
    public String resolveValue(String variableName) {
        BeanProperty p = this.beanProperties.get(variableName.toLowerCase());
        if (p == null) {
            return null;
        }
        Object value = p.get(this.beanInstance);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Map<String, BeanProperty> readProperties(Class<?> beanClass) {
        HashMap<String, BeanProperty> map = new HashMap<String, BeanProperty>();
        for (Method m : beanClass.getMethods()) {
            boolean isGet = m.getName().startsWith("get");
            boolean isIs = m.getName().startsWith("is");
            if (m.getParameterTypes().length != 0 || m.getName().equals("getClass") || !isGet && !isIs) continue;
            String getterName = isGet ? m.getName().substring(3) : m.getName().substring(2);
            BeanProperty p = new BeanProperty(m);
            map.put(getterName.toLowerCase(), p);
        }
        return map;
    }

    private static class BeanProperty {
        private Method m;

        public BeanProperty(Method m) {
            this.m = m;
        }

        public Object get(Object beanInstance) {
            try {
                return this.m.invoke(beanInstance, (Object[])null);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

