/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.progressmonitor;

import cern.colt.Timer;
import edu.upf.bg.progressmonitor.DefaultProgressMonitor;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.PrintStream;

public class StreamProgressMonitor
extends DefaultProgressMonitor {
    private static final String indentString = "  ";
    protected PrintStream out;
    protected Timer timer;
    protected int lastprogress;
    protected String tabs;
    protected boolean flag;
    protected boolean verbose;
    protected boolean debug;

    public StreamProgressMonitor(IProgressMonitor parent, PrintStream out, boolean verbose, boolean debug) {
        super(parent);
        this.out = out;
        this.timer = new Timer();
        this.lastprogress = 0;
        this.flag = false;
        this.tabs = "";
        this.verbose = verbose;
        this.debug = debug;
    }

    public StreamProgressMonitor(PrintStream out, boolean verbose, boolean debug) {
        this(null, out, verbose, debug);
    }

    @Override
    public void begin(String title, int totalWork) {
        super.begin(title, totalWork);
        this.flag = false;
        this.tabs = this.tabbulate(this.level);
        this.print("\n" + this.tabs + title);
        this.timer.start();
    }

    @Override
    public void title(String title) {
        super.title(title);
        this.print("\n" + this.tabs + title);
    }

    @Override
    public void worked(int workInc) {
        super.worked(workInc);
    }

    @Override
    public IProgressMonitor subtask() {
        IProgressMonitor subtask = this.createSubtaskMonitor(this, this.out, this.verbose, this.debug);
        subtask.setLevel(this.level + 1);
        this.flag = true;
        return subtask;
    }

    protected IProgressMonitor createSubtaskMonitor(IProgressMonitor parentMonitor, PrintStream out, boolean verbose, boolean debug) {
        return new StreamProgressMonitor(parentMonitor, out, verbose, debug);
    }

    @Override
    public void end() {
        super.end();
        double millis = this.timer.millis();
        double secs = this.timer.seconds();
        double mins = this.timer.minutes();
        String time = "";
        time = millis < 1000.0 ? Double.toString(millis) + " millisecs" : (secs < 60.0 ? Double.toString(secs) + " secs" : Double.toString(mins) + " mins");
        if (this.flag) {
            this.print("\n" + this.tabs + this.title + " " + time);
        } else {
            this.print(" " + time);
        }
    }

    @Override
    public void exception(Throwable cause) {
        super.exception(cause);
        this.print("\n\nEXCEPTION: " + cause.getLocalizedMessage());
    }

    @Override
    public void info(String msg) {
        if (this.verbose) {
            this.log(msg);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.debug) {
            this.log(msg);
        }
    }

    private void log(String msg) {
        this.print("\n" + this.tabs + indentString + msg);
        this.flag = true;
    }

    protected void print(String text) {
        this.out.print(text);
    }

    private String tabbulate(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append(indentString);
        }
        return sb.toString();
    }
}

