/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.progressmonitor;

import edu.upf.bg.progressmonitor.IProgressMonitor;

public class DefaultProgressMonitor
implements IProgressMonitor {
    protected String title;
    protected int totalWork;
    protected int worked;
    protected int level;
    protected boolean cancelled;
    protected Throwable cause;
    protected IProgressMonitor parent;

    public DefaultProgressMonitor() {
        this.title = "";
        this.level = 0;
        this.worked = 0;
        this.totalWork = 0;
        this.cancelled = false;
    }

    public DefaultProgressMonitor(IProgressMonitor parent) {
        this.parent = parent;
    }

    @Override
    public void begin(String title, int totalWork) {
        this.title = title;
        this.totalWork = totalWork;
        this.worked = 0;
        this.cancelled = false;
    }

    @Override
    public void title(String title) {
        this.title = title;
    }

    @Override
    public void worked(int workInc) {
        this.worked += workInc;
        if (this.worked > this.totalWork) {
            this.worked = this.totalWork;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void end() {
        this.worked = this.totalWork;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    public int getWorked() {
        return this.worked;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public IProgressMonitor subtask() {
        return new DefaultProgressMonitor(this);
    }

    @Override
    public void debug(String msg) {
    }

    @Override
    public void info(String msg) {
    }

    @Override
    public void exception(Throwable cause) {
        this.cause = cause;
        this.cancelled = true;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

