/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.formatter;

import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class GenericFormatter
implements Serializable {
    private static final long oneMicrosecond = 1000L;
    private static final long oneMilisecond = 1000000L;
    private static final long oneSecond = 1000000000L;
    private static final long oneMinute = 60000000000L;
    private static final long oneHour = 3600000000000L;
    private static final long oneDay = 86400000000000L;
    private static Map<Class<?>, String> defaultGenericFormatMap = new HashMap();
    private String ltString;
    private Map<Class<?>, String> genericFormatMap;
    private StringBuilder sb;
    private Formatter fmt;

    public GenericFormatter(String ltString) {
        this.ltString = ltString;
        this.genericFormatMap = defaultGenericFormatMap;
        this.sb = new StringBuilder(12);
        this.fmt = new Formatter(this.sb);
    }

    public GenericFormatter() {
        this("&lt;");
    }

    public String pvalue(double value) {
        if (value < 1.0E-16) {
            return this.ltString + "1.0e-16";
        }
        this.sb.setLength(0);
        this.fmt.format("%.3g", value);
        return this.sb.toString();
    }

    public String percentage(double value) {
        return this.format("%.2g%%", value * 100.0);
    }

    public String elapsedTime(Long elapsedTime) {
        return elapsedTime + " ns";
    }

    public String format(String format, Object ... args) {
        this.sb.setLength(0);
        this.fmt.format(format, args);
        return this.sb.toString();
    }

    public String format(Object value) {
        if (value == null) {
            return "null";
        }
        String format = this.genericFormatMap.get(value.getClass());
        if (format == null) {
            format = "%s";
        }
        this.sb.setLength(0);
        this.fmt.format(format, value);
        return this.sb.toString();
    }

    static {
        defaultGenericFormatMap.put(Float.class, "%.3g");
        defaultGenericFormatMap.put(Double.class, "%.3g");
    }
}

