/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.fileutils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    public static Reader openReader(File path) throws IOException {
        if (path == null) {
            return null;
        }
        if (path.getName().endsWith(".gz")) {
            return new InputStreamReader(new GZIPInputStream(new FileInputStream(path)));
        }
        return new BufferedReader(new FileReader(path));
    }

    public static Writer openWriter(File path) throws IOException {
        return IOUtils.openWriter(path, false);
    }

    public static Writer openWriter(File path, boolean append) throws IOException {
        if (path == null) {
            return null;
        }
        if (path.getName().endsWith(".gz")) {
            return new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(path, append)));
        }
        return new BufferedWriter(new FileWriter(path, append));
    }

    public static OutputStream openOutputStream(File path) throws IOException {
        return IOUtils.openOutputStream(path, false);
    }

    public static OutputStream openOutputStream(File path, boolean append) throws IOException {
        if (path == null) {
            return null;
        }
        if (path.getName().endsWith(".gz")) {
            return new GZIPOutputStream(new FileOutputStream(path, append));
        }
        return new BufferedOutputStream(new FileOutputStream(path, append));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream src, OutputStream dst) throws IOException {
        ReadableByteChannel source = null;
        WritableByteChannel destination = null;
        try {
            source = Channels.newChannel(src);
            destination = Channels.newChannel(dst);
            IOUtils.copyChannel(source, destination);
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static void copyChannel(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }
}

