/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.csv;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class RawCsvWriter {
    private PrintWriter out;
    private char separator;
    private char quote;

    public RawCsvWriter(Writer writer, char separator, char quote) {
        this.out = new PrintWriter(writer);
        this.separator = separator;
        this.quote = quote;
    }

    public void writeNewLine() {
        this.out.println();
    }

    public void writeValue(String value) {
        this.out.print(value);
    }

    public void writeQuotedValue(String value) {
        this.out.print(this.quote);
        this.out.print(value);
        this.out.print(this.quote);
    }

    public void writeProperty(String name, String value) {
        this.out.print(name);
        this.out.print(this.separator);
        this.writeQuotedValue(value);
        this.out.println();
    }

    public void writePropertyList(String name, String[] values) {
        this.out.print(name);
        if (values.length > 0) {
            for (String value : values) {
                this.out.print(this.separator);
                this.writeQuotedValue(value);
            }
        }
        this.out.println();
    }

    public void writePropertyList(String name, List<String> values) {
        this.out.print(name);
        if (values.size() > 0) {
            for (String value : values) {
                this.out.print(this.separator);
                this.writeQuotedValue(value);
            }
        }
        this.out.println();
    }

    public void writeSeparator() {
        this.out.print(this.separator);
    }

    public void write(String raw) {
        this.out.print(raw);
    }

    public void close() {
        this.out.close();
    }
}

