/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.csv;

import edu.upf.bg.csv.CSVException;
import edu.upf.bg.csv.CSVProcessor;
import edu.upf.bg.csv.CSVProcessorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class CSVReader {
    private static final CSVProcessor defaultProcessor = new CSVProcessorAdapter();
    private CharSequence seq;
    private Pattern pat;
    private Pattern patLineSep;
    private Pattern patRemoveQuotes;
    private Pattern patInternalQuotes;
    private int row;
    private Matcher matcher;

    public CSVReader(FileInputStream in, char sep, char quote) throws IOException {
        this.createCharSequence(in);
        this.createPattern(sep, quote);
        this.reset();
    }

    public CSVReader(File file, char sep, char quote) throws IOException {
        this(new FileInputStream(file), sep, quote);
    }

    private void createCharSequence(FileInputStream in) throws IOException {
        FileChannel channel = in.getChannel();
        MappedByteBuffer bbuf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)channel.size());
        this.seq = Charset.defaultCharset().newDecoder().decode(bbuf);
    }

    private void createPattern(char sep, char quote) {
        String regex = sep == ' ' ? "(q(?:[^q]|qq)*q|[^qs\\r\\n]*)(s+|s*\\r\\n?|s*\\n)?" : "( *q(?:[^q]|qq)*q *|[^qs\\r\\n]*)(s|\\r\\n?|\\n)?";
        String regexQuote = String.valueOf(quote);
        String regexSep = String.valueOf(sep);
        regex = regex.replaceAll("q", regexQuote);
        regex = regex.replaceAll("s", regexSep);
        this.pat = Pattern.compile(regex);
        regex = "\\r\\n?|\\n";
        this.patLineSep = Pattern.compile(regex);
        regex = "^q((?:[^q]|qq)*)q$";
        regex = regex.replaceAll("q", regexQuote);
        this.patRemoveQuotes = Pattern.compile(regex);
        regex = "(q)q";
        regex = regex.replaceAll("q", regexQuote);
        this.patInternalQuotes = Pattern.compile(regex);
    }

    public void scan(CSVProcessor proc) throws CSVException {
        if (proc == null) {
            proc = defaultProcessor;
        }
        if (this.row == 0) {
            proc.start();
        }
        while (this.internalScanLine(proc)) {
        }
        proc.end();
    }

    public boolean scanLine(CSVProcessor proc) throws CSVException {
        boolean endOfFile;
        if (proc == null) {
            proc = defaultProcessor;
        }
        if (this.row == 0) {
            proc.start();
        }
        boolean bl = endOfFile = !this.internalScanLine(proc);
        if (endOfFile) {
            proc.end();
        }
        return !endOfFile;
    }

    private boolean internalScanLine(CSVProcessor proc) throws CSVException {
        int col = 0;
        boolean endOfFile = false;
        boolean lastField = false;
        proc.lineStart(this.row);
        while (!lastField && this.matcher.find()) {
            String field = this.matcher.group(1);
            String sep = this.matcher.group(2);
            if (sep == null) {
                if (this.matcher.end() < this.seq.length()) {
                    throw new CSVException(this.row, col, "End of file expected.");
                }
                endOfFile = true;
                if (field.length() == 0 && col == 0) {
                    return !endOfFile;
                }
                lastField = true;
            } else {
                lastField = this.patLineSep.matcher(sep).matches();
            }
            Matcher mq = this.patRemoveQuotes.matcher(field.trim());
            field = mq.replaceAll("$1");
            mq = this.patInternalQuotes.matcher(field);
            field = mq.replaceAll("$1");
            proc.field(field, this.row, col++);
        }
        proc.lineEnd(this.row++);
        return !endOfFile;
    }

    public void reset() {
        this.row = 0;
        this.matcher = this.pat.matcher(this.seq);
    }
}

