/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.impl;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.NumericColorScale;
import edu.upf.bg.colorscale.util.ColorConstants;
import java.awt.Color;

public class ZScoreColorScale
extends NumericColorScale {
    private double center;
    private double halfAmplitude;
    private double sigHalfAmplitude;
    private Color leftMinColor;
    private Color leftMaxColor;
    private Color rightMinColor;
    private Color rightMaxColor;
    private Color nonSignificantColor;

    public ZScoreColorScale(double center, double halfAmplitude, double sigHalfAmplitude, Color leftMinColor, Color leftMaxColor, Color rightMinColor, Color rightMaxColor, Color nonSignificantColor) {
        this.center = center;
        this.halfAmplitude = halfAmplitude;
        this.sigHalfAmplitude = sigHalfAmplitude;
        this.leftMinColor = leftMinColor;
        this.leftMaxColor = leftMaxColor;
        this.rightMinColor = rightMinColor;
        this.rightMaxColor = rightMaxColor;
        this.nonSignificantColor = nonSignificantColor;
    }

    public ZScoreColorScale() {
        this(0.0, 10.0, 1.96, Color.BLUE, Color.CYAN, Color.YELLOW, Color.RED, ColorConstants.nonSignificantColor);
    }

    @Override
    protected Color colorOf(double value) {
        double absValue = Math.abs(value);
        if (absValue < this.sigHalfAmplitude) {
            return this.nonSignificantColor;
        }
        double f = (absValue - this.sigHalfAmplitude) / (this.halfAmplitude - this.sigHalfAmplitude);
        if (value > this.center) {
            return ColorUtils.mix(this.rightMaxColor, this.rightMinColor, f);
        }
        return ColorUtils.mix(this.leftMinColor, this.leftMaxColor, f);
    }

    @Override
    public double[] getPoints() {
        return new double[]{this.center - this.halfAmplitude, this.center - this.sigHalfAmplitude, this.center + this.sigHalfAmplitude, this.center + this.halfAmplitude};
    }

    public double getCenter() {
        return this.center;
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public double getHalfAmplitude() {
        return this.halfAmplitude;
    }

    public void setHalfAmplitude(double halfAmplitude) {
        this.halfAmplitude = halfAmplitude;
    }

    public double getSigHalfAmplitude() {
        return this.sigHalfAmplitude;
    }

    public void setSigHalfAmplitude(double sigHalfAmplitude) {
        this.sigHalfAmplitude = sigHalfAmplitude;
    }

    public Color getLeftMinColor() {
        return this.leftMinColor;
    }

    public void setLeftMinColor(Color leftMinColor) {
        this.leftMinColor = leftMinColor;
    }

    public Color getLeftMaxColor() {
        return this.leftMaxColor;
    }

    public void setLeftMaxColor(Color leftMaxColor) {
        this.leftMaxColor = leftMaxColor;
    }

    public Color getRightMinColor() {
        return this.rightMinColor;
    }

    public void setRightMinColor(Color rightMinColor) {
        this.rightMinColor = rightMinColor;
    }

    public Color getRightMaxColor() {
        return this.rightMaxColor;
    }

    public void setRightMaxColor(Color rightMaxColor) {
        this.rightMaxColor = rightMaxColor;
    }

    public Color getNonSignificantColor() {
        return this.nonSignificantColor;
    }

    public void setNonSignificantColor(Color nonSignificantColor) {
        this.nonSignificantColor = nonSignificantColor;
    }
}

