/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.impl;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.NumericColorScale;
import edu.upf.bg.colorscale.util.ColorConstants;
import java.awt.Color;

public class PValueColorScale
extends NumericColorScale {
    public static final double defaultLogFactor = 0.25;
    private double significanceLevel;
    private Color minColor;
    private Color maxColor;
    private Color nonSignificantColor;

    public PValueColorScale(double significanceLevel, Color minColor, Color maxColor, Color nonSignificantColor) {
        this.significanceLevel = significanceLevel;
        this.maxColor = maxColor;
        this.minColor = minColor;
        this.nonSignificantColor = nonSignificantColor;
    }

    public PValueColorScale() {
        this(0.05, ColorConstants.minColor, ColorConstants.maxColor, ColorConstants.nonSignificantColor);
    }

    @Override
    protected Color colorOf(double value) {
        if (value > this.significanceLevel || value < 0.0) {
            return this.nonSignificantColor;
        }
        double f = value / this.significanceLevel;
        f = f == 0.0 ? 0.0 : 1.0 + 0.25 * Math.log10(f);
        return ColorUtils.mix(this.maxColor, this.minColor, f);
    }

    @Override
    public double[] getPoints() {
        return new double[]{0.0, this.significanceLevel, 1.0};
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
        if (significanceLevel > 1.0) {
            this.significanceLevel = 1.0;
        }
        if (significanceLevel < 0.0) {
            this.significanceLevel = 0.0;
        }
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public void setMinColor(Color minColor) {
        this.minColor = minColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public void setMaxColor(Color maxColor) {
        this.maxColor = maxColor;
    }

    public Color getNonSignificantColor() {
        return this.nonSignificantColor;
    }

    public void setNonSignificantColor(Color nonSignificantColor) {
        this.nonSignificantColor = nonSignificantColor;
    }
}

