/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.impl;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.ColorScalePoint;
import edu.upf.bg.colorscale.NumericColorScale;
import java.awt.Color;

public class LinearTwoSidedColorScale
extends NumericColorScale {
    private ColorScalePoint min;
    private ColorScalePoint mid;
    private ColorScalePoint max;

    public LinearTwoSidedColorScale(ColorScalePoint min, ColorScalePoint mid, ColorScalePoint max) {
        this.min = min;
        this.mid = mid;
        this.max = max;
    }

    public LinearTwoSidedColorScale() {
        this(new ColorScalePoint(-2.0, Color.GREEN), new ColorScalePoint(0.0, Color.BLACK), new ColorScalePoint(2.0, Color.RED));
    }

    @Override
    protected Color colorOf(double value) {
        if (value < this.min.getValue()) {
            return this.min.getColor();
        }
        if (value > this.max.getValue()) {
            return this.max.getColor();
        }
        if (value < this.mid.getValue()) {
            double f = (value - this.min.getValue()) / (this.mid.getValue() - this.min.getValue());
            return ColorUtils.mix(this.mid.getColor(), this.min.getColor(), f);
        }
        double f = (value - this.mid.getValue()) / (this.max.getValue() - this.mid.getValue());
        return ColorUtils.mix(this.max.getColor(), this.mid.getColor(), f);
    }

    @Override
    public double[] getPoints() {
        return new double[]{this.min.getValue(), this.mid.getValue(), this.max.getValue()};
    }

    public ColorScalePoint getMin() {
        return this.min;
    }

    public void setMin(ColorScalePoint min) {
        this.min = min;
    }

    public ColorScalePoint getMid() {
        return this.mid;
    }

    public void setMid(ColorScalePoint mid) {
        this.mid = mid;
    }

    public ColorScalePoint getMax() {
        return this.max;
    }

    public void setMax(ColorScalePoint max) {
        this.max = max;
    }
}

