/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.impl;

import edu.upf.bg.colorscale.NumericColorScale;
import edu.upf.bg.colorscale.util.ColorConstants;
import edu.upf.bg.cutoffcmp.CutoffCmp;
import java.awt.Color;

public class BinaryColorScale
extends NumericColorScale {
    private String comparator;
    private double cutoff;
    private Color minColor;
    private Color maxColor;

    public BinaryColorScale(double cutoff, CutoffCmp cmp) {
        this.comparator = cmp.getShortName();
        this.cutoff = cutoff;
    }

    public BinaryColorScale() {
        this(1.0, CutoffCmp.EQ);
    }

    @Override
    protected Color colorOf(double value) {
        boolean satisfies = CutoffCmp.getFromName(this.comparator).compare(value, this.cutoff);
        return satisfies ? this.getMaxColor() : this.getMinColor();
    }

    @Override
    public double[] getPoints() {
        double edge = Math.abs(this.cutoff) * 1.5;
        if (edge < 0.5) {
            edge = 0.5;
        }
        return new double[]{-edge, this.cutoff, edge};
    }

    public Color getMinColor() {
        if (this.minColor == null) {
            return ColorConstants.binaryMinColor;
        }
        return this.minColor;
    }

    public void setMinColor(Color minColor) {
        this.minColor = minColor;
    }

    public Color getMaxColor() {
        if (this.maxColor == null) {
            return ColorConstants.binaryMaxColor;
        }
        return this.maxColor;
    }

    public void setMaxColor(Color maxColor) {
        this.maxColor = maxColor;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }
}

