/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.drawer;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.drawer.ColorScaleDrawer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class ColorScalePanel
extends JPanel {
    private IColorScale scale;
    private ColorScaleDrawer drawer;

    public ColorScalePanel(IColorScale scale) {
        this.setScale(scale);
    }

    public IColorScale getScale() {
        return this.scale;
    }

    public void setScale(IColorScale scale) {
        this.scale = scale;
        this.drawer = new ColorScaleDrawer(scale);
        this.setPreferredSize(this.drawer.getSize());
        this.repaint();
    }

    public void update() {
        this.drawer.resetZoom();
        this.setPreferredSize(this.drawer.getSize());
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Rectangle box = new Rectangle(0, 0, size.width, size.height);
        Rectangle clip = g.getClipBounds();
        this.drawer.draw((Graphics2D)g, box, clip);
    }
}

